/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction.extraction;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.xmlpivot.extraction.emftools.EMFToolBox;
import org.polarsys.capella.xmlpivot.extraction.extraction.MMAbstractStats;
import org.polarsys.capella.xmlpivot.extraction.extraction.MMExtractionSimplifiedMetadata;

public class MMSimplificationStats
extends MMAbstractStats {
    private final MMExtractionSimplifiedMetadata _meta;

    public MMSimplificationStats(Collection<EPackage> collection_p, MMExtractionSimplifiedMetadata meta_p) {
        super(collection_p);
        this._meta = meta_p;
    }

    @Override
    public void getStatsOnMModelCleaning() {
        for (EPackage current : this._ePackages) {
            this.statsOnPackage(current);
        }
        this.showStats();
    }

    private void statsOnPackage(EPackage pack) {
        if (!this._meta.isMarked((EModelElement)pack)) {
            ++this._stats_supp_packages;
        } else {
            ++this._stats_notsupp_packages;
        }
        EList objlist = pack.getEClassifiers();
        for (EClassifier current : objlist) {
            if (current instanceof EClass) {
                EClass cls = (EClass)current;
                if (!this._meta.isConserved((EClassifier)cls)) {
                    ++this._stats_supp_classes;
                } else {
                    ++this._stats_notsupp_classes;
                }
                this.statsOnClass(cls);
                continue;
            }
            if (!this._meta.isConserved(current)) {
                ++this._stats_supp_enumORtypes;
                System.out.println("ENUM or TYPE SUPPRESSED: " + current.getEPackage().getName() + "::" + current.getName());
                continue;
            }
            ++this._stats_notsupp_enumORtypes;
        }
        EList subpcklist = pack.getESubpackages();
        for (EPackage currentPack : subpcklist) {
            this.statsOnPackage(currentPack);
        }
    }

    private void statsOnClass(EClass clazz) {
        for (EStructuralFeature current : clazz.getEStructuralFeatures()) {
            if (current instanceof EAttribute) {
                if (this._meta.isNavigable(current)) {
                    ++this._stats_notsupp_attributes;
                } else if (!EMFToolBox.getInstance().isPrimitiveEMFType(current.getEType())) {
                    ++this._stats_supp_attributes;
                    System.out.println("ATTRIBUTES SUPPRESSED as NOT ANNOTATED TO BE REMOVED and NOT NAVIGABLE: " + current.getEContainingClass().getEPackage().getName() + "::" + current.getEContainingClass().getName() + "::" + current.getName());
                } else {
                    ++this._stats_notsupp_attributes;
                }
            }
            if (!(current instanceof EReference)) continue;
            if (this._meta.isNavigable(current)) {
                ++this._stats_notsupp_references;
                continue;
            }
            ++this._stats_supp_references;
        }
    }
}

