/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction;

import com.google.common.collect.Ordering;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreFactory;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreMappingRoot;
import org.polarsys.capella.xmlpivot.common.functions.EMFFunctions;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.extraction.MMSimplifier;
import org.polarsys.capella.xmlpivot.extraction.mapping.HashIterableInvertibleBinaryRelation;
import org.polarsys.capella.xmlpivot.extraction.mapping.MMInvertibleRelationCopyMappingGenerator;

public class ExportActionLauncher {
    ExportActionLauncher() {
    }

    public Result launch(Collection<EPackage> sourcePackages_p, ConceptualMapping context, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashIterableInvertibleBinaryRelation invertibleMapping = new MMInvertibleRelationCopyMappingGenerator().generateTotalCopyMapping(this.findAllNeededPackages(sourcePackages_p, context));
        progress.worked(50);
        MMSimplifier.getInstance().simplifyAllModels(invertibleMapping, false, true);
        Result result = new Result(invertibleMapping.getContents());
        this.replaceExternalReferences(result.getTargetPackages(), context);
        progress.worked(50);
        return result;
    }

    private void replace(EObject referent, EReference reference, EObject oldRef, EObject newRef) {
        if (reference.isMany()) {
            List list = (List)referent.eGet((EStructuralFeature)reference);
            int index = list.indexOf(oldRef);
            list.remove(index);
            list.add(index, newRef);
        } else {
            referent.eSet((EStructuralFeature)reference, (Object)newRef);
        }
    }

    protected Collection<EStructuralFeature.Setting> replaceExternalReferences(Collection<EPackage> packages_p, ConceptualMapping context) {
        ArrayList<EStructuralFeature.Setting> missingSimplified = new ArrayList<EStructuralFeature.Setting>();
        Map<EObject, Collection<EStructuralFeature.Setting>> externalReferences = CrossReferencer.find(packages_p);
        for (EObject e : externalReferences.keySet()) {
            for (EStructuralFeature.Setting setting : externalReferences.get(e)) {
                if (!(e instanceof EModelElement) || !(setting.getEStructuralFeature() instanceof EReference)) continue;
                EModelElement simplified = context.getSimplified((EModelElement)e);
                if (simplified != null) {
                    this.replace(setting.getEObject(), (EReference)setting.getEStructuralFeature(), e, (EObject)simplified);
                    continue;
                }
                missingSimplified.add(setting);
            }
        }
        return missingSimplified;
    }

    private Collection<EPackage> findAllNeededPackages(Collection<EPackage> sourcePackages_p, ConceptualMapping context) {
        HashSet<EPackage> allRequiredPackages = new HashSet<EPackage>();
        HashSet<EPackage> skippedPackages = new HashSet<EPackage>();
        ArrayDeque<EPackage> pkgs = new ArrayDeque<EPackage>(new HashSet<EPackage>(sourcePackages_p));
        while (!pkgs.isEmpty()) {
            EPackage ePackage = (EPackage)pkgs.pop();
            if (ePackage.getESuperPackage() != null) {
                pkgs.push(ePackage.getESuperPackage());
                continue;
            }
            if (context.getSimplified(ePackage) != null) {
                skippedPackages.add(ePackage);
                continue;
            }
            if (!allRequiredPackages.add(ePackage)) continue;
            TreeIterator it = ePackage.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                for (EObject ref : next.eCrossReferences()) {
                    if (!(ref instanceof EClassifier)) continue;
                    pkgs.add(((EClassifier)ref).getEPackage());
                }
            }
        }
        return allRequiredPackages;
    }

    static class CrossReferencer
    extends EcoreUtil.ExternalCrossReferencer {
        protected CrossReferencer(Collection<?> emfObjects_p) {
            super(emfObjects_p);
        }

        protected boolean crossReference(EObject eObject_p, EReference eReference_p, EObject crossReferencedEObject_p) {
            if (super.crossReference(eObject_p, eReference_p, crossReferencedEObject_p)) {
                if (eReference_p.isDerived()) {
                    return false;
                }
                if (crossReferencedEObject_p instanceof EClassifier && ((EClassifier)crossReferencedEObject_p).getEPackage() == EcorePackage.eINSTANCE) {
                    return false;
                }
                return eReference_p != EcorePackage.Literals.EPACKAGE__EFACTORY_INSTANCE;
            }
            return false;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(Collection<?> emfObjectsToSearch) {
            return new CrossReferencer(emfObjectsToSearch).findExternalCrossReferences();
        }
    }

    public class Result {
        private final EMap<EObject, List<EObject>> _mapping;

        Result(EMap<EObject, List<EObject>> mapping_p) {
            this._mapping = mapping_p;
        }

        public EMap<EObject, List<EObject>> getRawMapping() {
            return this._mapping;
        }

        public Ecore2EcoreMappingRoot getEcore2EcoreMapping() {
            Ecore2EcoreFactory factory = Ecore2EcoreFactory.eINSTANCE;
            MappingFactory mapfactory = MappingFactory.eINSTANCE;
            Ecore2EcoreMappingRoot mappingmodel = factory.createEcore2EcoreMappingRoot();
            Ordering byURI = Ordering.natural().onResultOf(EMFFunctions.eObjectToUriString());
            for (EObject sortedKey : byURI.sortedCopy((Iterable)this._mapping.keySet())) {
                List sortedValues = byURI.sortedCopy((Iterable)this._mapping.get((Object)sortedKey));
                if (sortedValues.isEmpty()) continue;
                Mapping mapping = mapfactory.createMapping();
                mapping.getInputs().add((Object)sortedKey);
                mapping.getOutputs().addAll((Collection)sortedValues);
                mappingmodel.getNested().add((Object)mapping);
            }
            return mappingmodel;
        }

        public Collection<EPackage> getTargetPackages() {
            TreeSet<EPackage> result = new TreeSet<EPackage>(new Comparator<EPackage>(){

                @Override
                public int compare(EPackage o1_p, EPackage o2_p) {
                    return o1_p.getNsPrefix().compareTo(o2_p.getNsPrefix());
                }
            });
            for (Map.Entry entry : this._mapping.entrySet()) {
                if (!(entry.getKey() instanceof EPackage)) continue;
                result.add((EPackage)((List)entry.getValue()).get(0));
            }
            return new ArrayList<EPackage>(result);
        }

        public ResourceSet save(URI destinationDir, boolean saveXMLSchema) throws Exception {
            if (destinationDir.lastSegment().equals("")) {
                destinationDir = destinationDir.trimSegments(1);
            }
            ResourceSetImpl rs = new ResourceSetImpl();
            EcoreResourceFactoryImpl ecoreResourceFactory = new EcoreResourceFactoryImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", ecoreResourceFactory);
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", ecoreResourceFactory);
            StringBuilder genModelBuilder = new StringBuilder();
            for (EPackage p : this.getTargetPackages()) {
                if (p.getESuperPackage() != null) continue;
                URI targetURI = destinationDir.appendSegment(String.valueOf(p.getName()) + ".ecore");
                Resource resource = rs.getResource(targetURI, false);
                if (resource != null) {
                    throw new IllegalStateException("Colliding destination URIs for EPackages: " + p + ", " + (EPackage)resource.getContents().get(0));
                }
                resource = rs.createResource(targetURI);
                resource.getContents().add((Object)p);
                genModelBuilder.append(String.valueOf(targetURI.toString()) + "\n");
            }
            Resource mappingResource = rs.createResource(destinationDir.appendSegment("mapping.ecore2ecore"));
            mappingResource.getContents().add((Object)this.getEcore2EcoreMapping());
            for (Resource res : rs.getResources()) {
                res.save(Collections.emptyMap());
            }
            return rs;
        }
    }
}

