/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformExtensionPoint;
import org.eclipse.egf.core.platform.l10n.CorePlatformMessages;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.bundle.BundleFragment;
import org.osgi.framework.Bundle;

class PlatformBundle
implements IPlatformBundle {
    private Bundle _bundle;
    private IPluginModelBase _base;
    private String _previousBundleId;
    private Map<Class<?>, Map<String, Object>> _extensions = new HashMap();

    public PlatformBundle(IPluginModelBase base) {
        Assert.isNotNull((Object)base);
        Assert.isNotNull((Object)BundleHelper.getBundleId((IPluginModelBase)base));
        this._base = base;
        this._previousBundleId = BundleHelper.getBundleId((IPluginModelBase)base);
    }

    public PlatformBundle(Bundle bundle) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)bundle.getSymbolicName());
        this._bundle = bundle;
        this._previousBundleId = bundle.getSymbolicName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._base == null ? 0 : this._base.hashCode());
        result = 31 * result + (this._bundle == null ? 0 : this._bundle.hashCode());
        result = 31 * result + (this._previousBundleId == null ? 0 : this._previousBundleId.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPlatformBundle)) {
            return false;
        }
        if (this.getPluginModelBase() != null && ((IPlatformBundle)object).getPluginModelBase() != null) {
            return this.getPluginModelBase() == ((IPlatformBundle)object).getPluginModelBase();
        }
        if (this.getBundle() != null && ((IPlatformBundle)object).getBundle() != null) {
            return this.getBundle() == ((IPlatformBundle)object).getBundle();
        }
        return false;
    }

    @Override
    public String getBundleId() {
        if (this._base != null) {
            return BundleHelper.getBundleId((IPluginModelBase)this._base);
        }
        return this.getBundle().getSymbolicName();
    }

    @Override
    public String getPreviousBundleId() {
        return this._previousBundleId;
    }

    @Override
    public IPluginModelBase getPluginModelBase() {
        if (!this.isRuntime()) {
            return this._base;
        }
        IPluginModelBase base = PluginRegistry.findModel((String)this.getBundleId());
        if (base == null) {
            return null;
        }
        if (base.getPluginBase().getVersion() != null && base.getPluginBase().getVersion().equals(this._bundle.getVersion().toString())) {
            return base;
        }
        return null;
    }

    @Override
    public boolean isFragment() {
        if (this.getPluginModelBase() != null) {
            return this.getPluginModelBase().isFragmentModel();
        }
        return this.getBundle() instanceof BundleFragment;
    }

    @Override
    public IProject getProject() {
        if (this.isWorkspace()) {
            return this.getPluginModelBase().getUnderlyingResource().getProject();
        }
        return null;
    }

    @Override
    public Bundle getBundle() {
        if (this.isWorkspace()) {
            return null;
        }
        if (this.isRuntime()) {
            return this._bundle;
        }
        Bundle bundle = Platform.getBundle((String)this.getBundleId());
        if (bundle == null) {
            return null;
        }
        return bundle;
    }

    @Override
    public boolean isRuntime() {
        return this._bundle != null;
    }

    @Override
    public boolean isTarget() {
        if (!this.isRuntime()) {
            return this.getPluginModelBase().getUnderlyingResource() == null;
        }
        return false;
    }

    @Override
    public boolean isWorkspace() {
        return !this.isRuntime() && !this.isTarget();
    }

    protected <T extends IPlatformExtensionPoint> T createPlatformExtensionPoint(Class<T> clazz, Object element) {
        IPlatformExtensionPoint extensionPoint;
        block13: {
            Map<String, Object> extensionPoints;
            block12: {
                IPlatformExtensionPointFactory<? extends IPlatformExtensionPoint> extensionPointFactory;
                if (element instanceof IPluginElement) {
                    if (!((IPluginElement)element).isValid()) {
                        EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformBundle.createPlatformExtensionPoint(..) _ Bundle ''{0}'' invalid IPluginElement ''{1}''.", (Object)this.getBundleId(), (Object)((IPluginElement)element).getName()));
                        return null;
                    }
                } else if (element instanceof IConfigurationElement) {
                    if (!((IConfigurationElement)element).isValid()) {
                        EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformBundle.createPlatformExtensionPoint(..) _ Bundle ''{0}'' invalid IConfigurationElement ''{1}''.", (Object)this.getBundleId(), (Object)((IConfigurationElement)element).getName()));
                        return null;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                if ((extensionPointFactory = EGFPlatformPlugin.getPlatformExtensionPointFactories().get(clazz)) == null) {
                    return null;
                }
                extensionPoint = extensionPointFactory.createExtensionPoint(this, element);
                if (extensionPoint == null) {
                    return null;
                }
                extensionPoints = this._extensions.get(clazz);
                if (extensionPoints == null) {
                    extensionPoints = new HashMap<String, Object>();
                    this._extensions.put(clazz, extensionPoints);
                }
                try {
                    if (extensionPoints.get(extensionPoint.getId()) == null) break block12;
                    EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformBundle.createPlatformExtensionPoint(..) _ Bundle ''{0}'' already contains Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
                }
                catch (Throwable t) {
                    EGFPlatformPlugin.getDefault().logError("PlatformBundle.createPlatformExtensionPoint(..)", t);
                    return null;
                }
                return null;
            }
            if (extensionPoints.put(extensionPoint.getId(), extensionPoint) == null) break block13;
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformBundle.createPlatformExtensionPoint(..) _ Bundle ''{0}'' unable to add Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            return null;
        }
        return (T)((IPlatformExtensionPoint)clazz.cast(extensionPoint));
    }

    protected void addPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            return;
        }
        Map<String, Object> extensionPoints = this._extensions.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new HashMap<String, Object>();
            this._extensions.put(clazz, extensionPoints);
        }
        try {
            if (extensionPoints.get(extensionPoint.getId()) != null) {
                EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformBundle.addPlatformExtensionPoint(..) _ Bundle ''{0}'' already contains Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            }
            if (extensionPoints.put(extensionPoint.getId(), extensionPoint) != null) {
                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformBundle.addPlatformExtensionPoint(..) _ Bundle ''{0}'' unable to add Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            }
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).setPlatformBundle(this);
        }
        catch (Throwable t) {
            EGFPlatformPlugin.getDefault().logError("PlatformBundle.addPlatformExtensionPoint(..)", t);
        }
    }

    @Override
    public IPlatformExtensionPoint[] getPlatformExtensionPoints() {
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        for (Map<String, Object> extensionPoint : this._extensions.values()) {
            extensionPoints.addAll(extensionPoint.values());
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Map<String, Object> extensions;
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        if (clazz != null && EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) && (extensions = this._extensions.get(clazz)) != null) {
            extensionPoints.addAll(extensions.values());
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    protected boolean removePlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) || extensionPoint == null) {
            return false;
        }
        if (this._extensions.get(clazz) != null && this._extensions.get(clazz).remove(extensionPoint.getId()) != null) {
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            if (this._extensions.get(clazz) == null || this._extensions.get(clazz).size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPlatformExtensionPoint(IPlatformExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            return false;
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            if (!this.hasPlatformExtensionPoint(clazz, extensionPoint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) || extensionPoint == null) {
            return false;
        }
        return this._extensions.get(clazz) != null && this._extensions.get(clazz).get(extensionPoint.getId()) != null;
    }

    @Override
    public String getInstallLocation() {
        if (this.isRuntime()) {
            try {
                return FileLocator.getBundleFile((Bundle)this.getBundle()).getAbsolutePath();
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return this.getPluginModelBase().getInstallLocation();
    }

    @Override
    public URI getUnrootedBase() {
        return URI.createURI((String)("platform:/plugin/" + this.getBundleId()));
    }

    @Override
    public URI getRootedBase() {
        return URI.createURI((String)("platform:/plugin/" + this.getBundleId() + "/"));
    }

    public String toString() {
        IPluginBase pluginBase;
        String id = this.getBundleId();
        String previousId = this.getPreviousBundleId();
        StringBuilder text = new StringBuilder();
        text.append(id);
        if (!id.equals(previousId)) {
            text.append(" PreviousId: ").append(previousId);
        }
        if (this.getPluginModelBase() != null && (pluginBase = this.getPluginModelBase().getPluginBase()).getModel() != null && !pluginBase.getModel().isInSync()) {
            text.append(" ").append(CorePlatformMessages.PlatformManager_outOfSync);
        }
        if (this.isTarget()) {
            text.append(" [Target]");
        } else if (this.isWorkspace()) {
            text.append(" [Workspace]");
        } else {
            text.append(" [Runtime]");
        }
        if (this.getInstallLocation() != null) {
            text.append(" [").append(this.getInstallLocation()).append("]");
        }
        return text.toString();
    }
}

