/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;
import org.polarsys.capella.docgen.util.pattern.helper.FunctionHelper;

public class CapellaFunctionServices {
    public static Collection<FunctionalExchange> getIncomingFunctionalExchanges(AbstractFunction function) {
        ArrayList<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
        Collection<ActivityEdge> incomingActivityEdges = CapellaFunctionServices.getIncomingActivityEdges(function);
        for (ActivityEdge activityEdge : incomingActivityEdges) {
            if (!(activityEdge instanceof FunctionalExchange)) continue;
            functionalExchanges.add((FunctionalExchange)activityEdge);
        }
        return functionalExchanges;
    }

    private static Collection<ActivityEdge> getIncomingActivityEdges(AbstractFunction abstractFunction) {
        if (abstractFunction instanceof AbstractFunction) {
            ArrayList<ActivityEdge> activityEdges = new ArrayList<ActivityEdge>();
            for (InputPin inputPin : abstractFunction.getInputs()) {
                activityEdges.addAll((Collection<ActivityEdge>)inputPin.getIncoming());
            }
            for (ActivityEdge iActivityEdge : abstractFunction.getIncoming()) {
                if (activityEdges.contains(iActivityEdge)) continue;
                activityEdges.add(iActivityEdge);
            }
            return activityEdges;
        }
        if (abstractFunction instanceof ActivityNode) {
            return abstractFunction.getIncoming();
        }
        return Collections.emptyList();
    }

    public static Collection<FunctionalExchange> getIncomingInternalFunctionalExchanges(AbstractFunction function) {
        ArrayList<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
        for (AbstractFunction abstractFunction : CapellaFunctionServices.getAllSubFunctions(function)) {
            Collection<FunctionalExchange> allIncomingFunctionalExchanges = CapellaFunctionServices.getIncomingFunctionalExchanges(abstractFunction);
            for (FunctionalExchange currentFunctionalExchange : allIncomingFunctionalExchanges) {
                if (!CapellaFunctionServices.containsExternalSource(currentFunctionalExchange, function)) continue;
                functionalExchanges.add(currentFunctionalExchange);
            }
        }
        return functionalExchanges;
    }

    public static Collection<FunctionalExchange> getOutgoingFunctionalExchanges(AbstractFunction function) {
        ArrayList<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
        for (ActivityEdge activityEdge : CapellaFunctionServices.getOutgoingActivityEdges(function)) {
            if (!(activityEdge instanceof FunctionalExchange)) continue;
            functionalExchanges.add((FunctionalExchange)activityEdge);
        }
        return functionalExchanges;
    }

    private static Collection<ActivityEdge> getOutgoingActivityEdges(AbstractFunction abstractFunction) {
        if (abstractFunction instanceof AbstractFunction) {
            ArrayList<ActivityEdge> activityEdges = new ArrayList<ActivityEdge>();
            for (OutputPin outputPin : abstractFunction.getOutputs()) {
                activityEdges.addAll((Collection<ActivityEdge>)outputPin.getOutgoing());
            }
            for (ActivityEdge iActivityEdge : abstractFunction.getOutgoing()) {
                if (activityEdges.contains(iActivityEdge)) continue;
                activityEdges.add(iActivityEdge);
            }
            return activityEdges;
        }
        if (abstractFunction instanceof ActivityNode) {
            return abstractFunction.getOutgoing();
        }
        return Collections.emptyList();
    }

    public static Collection<FunctionalExchange> getOutgoingInternalFunctionalExchanges(AbstractFunction function) {
        ArrayList<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
        for (AbstractFunction abstractFunction : CapellaFunctionServices.getAllSubFunctions(function)) {
            Collection<FunctionalExchange> allOutgoingFunctionalExchanges = CapellaFunctionServices.getOutgoingFunctionalExchanges(abstractFunction);
            for (FunctionalExchange currentFunctionalExchange : allOutgoingFunctionalExchanges) {
                if (!CapellaFunctionServices.containsExternalTarget(currentFunctionalExchange, function)) continue;
                functionalExchanges.add(currentFunctionalExchange);
            }
        }
        return functionalExchanges;
    }

    public static Collection<String> getAvailableModeAndState(String projectName, String outputFolder, AbstractFunction abstractFunction) {
        ArrayList<String> ret = new ArrayList<String>();
        for (State currentStateMode : abstractFunction.getAvailableInStates()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentStateMode, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentStateMode));
            ret.add(buffer.toString());
        }
        return ret;
    }

    private static boolean containsExternalTarget(FunctionalExchange currentFunctionalExchange, AbstractFunction function) {
        Collection<ActivityNode> targetFunctions = CapellaFunctionServices.getTargetFunctions(currentFunctionalExchange);
        for (ActivityNode currentFunction : targetFunctions) {
            if (EcoreUtil.isAncestor((EObject)function, (EObject)currentFunction)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsExternalSource(FunctionalExchange currentFunctionalExchange, AbstractFunction function) {
        Collection<ActivityNode> sourceFunctions = CapellaFunctionServices.getSourceFunctions(currentFunctionalExchange);
        for (ActivityNode currentFunction : sourceFunctions) {
            if (EcoreUtil.isAncestor((EObject)function, (EObject)currentFunction)) continue;
            return true;
        }
        return false;
    }

    private static Collection<ActivityNode> getSourceFunctions(FunctionalExchange functionalExchange) {
        ArrayList<ActivityNode> sourceFunctions = new ArrayList<ActivityNode>();
        ActivityNode sourceActivityNode = functionalExchange.getSource();
        if (sourceActivityNode instanceof FunctionOutputPort) {
            sourceFunctions.add((ActivityNode)((AbstractFunction)sourceActivityNode.eContainer()));
        } else if (sourceActivityNode != null) {
            sourceFunctions.add(sourceActivityNode);
        }
        return sourceFunctions;
    }

    private static Collection<ActivityNode> getTargetFunctions(FunctionalExchange functionalExchange) {
        ArrayList<ActivityNode> targetFunctions = new ArrayList<ActivityNode>();
        ActivityNode targetActivityNode = functionalExchange.getTarget();
        if (targetActivityNode instanceof FunctionInputPort) {
            targetFunctions.add((ActivityNode)((AbstractFunction)targetActivityNode.eContainer()));
        } else if (targetActivityNode != null) {
            targetFunctions.add(targetActivityNode);
        }
        return targetFunctions;
    }

    private static String getDescription(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        if (functionalExchange.getDescription() != null) {
            return StringUtil.transformAREFString((EObject)functionalExchange, functionalExchange.getDescription(), projectName, outputFolder);
        }
        return "";
    }

    public static String incomingFunctionalExchangeToTableLine(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        return CapellaFunctionServices.functionalExchangeToTableLine(functionalExchange, false, true, projectName, outputFolder);
    }

    public static String outgoingFunctionalExchangeToTableLine(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        return CapellaFunctionServices.functionalExchangeToTableLine(functionalExchange, false, false, projectName, outputFolder);
    }

    public static String externalFunctionalExchangeToTableLine(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        return CapellaFunctionServices.functionalExchangeToTableLine(functionalExchange, true, true, projectName, outputFolder);
    }

    private static String functionalExchangeToTableLine(FunctionalExchange functionalExchange, boolean external, boolean incoming, String projectName, String outputFolder) {
        FunctionOutputPort distantPort;
        StringBuffer buffer = new StringBuffer();
        Object object = distantPort = incoming ? functionalExchange.getSourceFunctionOutputPort() : functionalExchange.getTargetFunctionInputPort();
        if (distantPort != null) {
            buffer.append("<tr>");
            buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)functionalExchange) + "\">");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)functionalExchange));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getInvolvingFunctionalChains(projectName, outputFolder, functionalExchange));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getAllocatingComponentExchangess(projectName, outputFolder, functionalExchange));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)distantPort));
            buffer.append("</td>");
            buffer.append("<td>");
            Collection<ActivityNode> activityNodes = incoming ? CapellaFunctionServices.getSourceFunctions(functionalExchange) : CapellaFunctionServices.getTargetFunctions(functionalExchange);
            for (ActivityNode currentFunction : activityNodes) {
                buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)currentFunction));
            }
            buffer.append("</td>");
            if (external) {
                buffer.append("<td>");
                Collection<ActivityNode> activityNodesExternal = !incoming ? CapellaFunctionServices.getSourceFunctions(functionalExchange) : CapellaFunctionServices.getTargetFunctions(functionalExchange);
                for (ActivityNode currentFunction : activityNodesExternal) {
                    buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)currentFunction));
                }
                buffer.append("</td>");
            }
            buffer.append("<td>");
            buffer.append(CapellaFunctionServices.getDescription(functionalExchange, projectName, outputFolder));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getExchangedItems(functionalExchange, projectName, outputFolder));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getRealizedFunctionalExchanges(functionalExchange, projectName, outputFolder));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getRealizingFunctionalExchanges(functionalExchange, projectName, outputFolder));
            buffer.append("</td>");
            buffer.append("</tr>");
        }
        return buffer.toString();
    }

    public static String incomingInteractionToTableLine(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        return CapellaFunctionServices.interactionToTableLine(functionalExchange, false, true, false, projectName, outputFolder);
    }

    public static String outgoingInteractionToTableLine(FunctionalExchange functionalExchange, String projectName, String outputFolder) {
        return CapellaFunctionServices.interactionToTableLine(functionalExchange, false, false, false, projectName, outputFolder);
    }

    public static String externalInteractionToTableLine(FunctionalExchange activityEdge, String projectName, String outputFolder) {
        return CapellaFunctionServices.interactionToTableLine(activityEdge, true, true, true, projectName, outputFolder);
    }

    private static String interactionToTableLine(FunctionalExchange activityEdge, boolean external, boolean incoming, boolean showBothSourceAndTarget, String projectName, String outputFolder) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)activityEdge) + "\">");
        buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)activityEdge));
        buffer.append("</td>");
        if (external) {
            buffer.append("<td>");
            buffer.append(FunctionHelper.getInvolvingFunctionalChains(projectName, outputFolder, activityEdge));
            buffer.append("</td>");
        }
        if (incoming || showBothSourceAndTarget) {
            buffer.append("<td>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)activityEdge.getSource()));
            buffer.append("</td>");
        }
        if (!incoming || showBothSourceAndTarget) {
            buffer.append("<td>");
            buffer.append(CapellaServices.buildHyperlinkWithIcon(projectName, outputFolder, (EObject)activityEdge.getTarget()));
            buffer.append("</td>");
        }
        buffer.append("<td>");
        buffer.append(CapellaFunctionServices.getDescription(activityEdge, projectName, outputFolder));
        buffer.append("</td>");
        buffer.append("<td>");
        buffer.append(FunctionHelper.getExchangedItems(activityEdge, projectName, outputFolder));
        buffer.append("</td>");
        if (external) {
            buffer.append("<td>");
            buffer.append(FunctionHelper.getRealizedFunctionalExchanges(activityEdge, projectName, outputFolder));
            buffer.append("</td>");
            buffer.append("<td>");
            buffer.append(FunctionHelper.getRealizingFunctionalExchanges(activityEdge, projectName, outputFolder));
            buffer.append("</td>");
        }
        buffer.append("</tr>");
        return buffer.toString();
    }

    private static Collection<AbstractFunction> getAllSubFunctions(AbstractFunction function) {
        ArrayList<AbstractFunction> abstractFunctions = new ArrayList<AbstractFunction>();
        for (AbstractFunction currentAbstractFunction : function.getOwnedFunctions()) {
            abstractFunctions.add(currentAbstractFunction);
            if (!(currentAbstractFunction instanceof AbstractFunction)) continue;
            abstractFunctions.addAll(CapellaFunctionServices.getAllSubFunctions(currentAbstractFunction));
        }
        return abstractFunctions;
    }
}

