/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaCollectionService {
    private CapellaCollectionService() {
    }

    public static List<String> getCollectionFeatures(EObject eObject) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Collection) {
            Collection eCollection = (Collection)eObject;
            ret.add("<b>Is Abstract\t:\t</b>" + eCollection.isAbstract());
            ret.add("<b>static   : </b>" + eCollection.isIsPrimitive());
            ret.add("<b>ordered   : </b>" + eCollection.isOrdered());
            ret.add("<b>unique   : </b>" + eCollection.isUnique());
            if (eCollection.getOwnedMaxValue() != null) {
                ret.add("<b>MIN   : </b>" + CapellaDataValueServices.getValueOfDataValue(eCollection.getOwnedMaxValue()));
            }
            if (eCollection.getOwnedMinValue() != null) {
                ret.add("<b>MAX   : </b>" + CapellaDataValueServices.getValueOfDataValue(eCollection.getOwnedMinValue()));
            }
            if (eCollection.getOwnedDefaultValue() != null) {
                ret.add("<b>Default\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(eCollection.getOwnedDefaultValue()));
            }
            if (eCollection.getOwnedNullValue() != null) {
                ret.add("<b>Null\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(eCollection.getOwnedNullValue()));
            }
        }
        return ret;
    }

    public static List<String> getCollectionElements(EObject eObject) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject instanceof Collection) {
            Collection eCollection = (Collection)eObject;
            StringBuilder stringBuilder = new StringBuilder();
            NumericValue ownedMinCard = eCollection.getOwnedMinCard();
            if (ownedMinCard != null) {
                stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)ownedMinCard));
            } else {
                stringBuilder.append("<undefined>");
            }
            stringBuilder.append(" \n");
            NumericValue ownedMaxCard = eCollection.getOwnedMaxCard();
            if (ownedMaxCard != null) {
                stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)ownedMaxCard));
            } else {
                stringBuilder.append("<undefined>");
            }
            ret.add(stringBuilder.toString());
        }
        return ret;
    }

    public static List<String> getIndexedBy(Collection collection, String projectName, String outputFolder) {
        ArrayList<String> informations = new ArrayList<String>();
        for (DataType currentDataType : collection.getIndex()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)collection, projectName, outputFolder));
            stringBuilder.append(" ");
            stringBuilder.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)currentDataType));
            informations.add(stringBuilder.toString());
        }
        return informations;
    }
}

