/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaEntityHelper {
    public static Collection<String> getIncomingCommunicationMeansLines(Entity entity, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractInformationFlow informationFlow : entity.getIncomingInformationFlows()) {
            if (!(informationFlow instanceof CommunicationMean)) continue;
            CommunicationMean communicationMean = (CommunicationMean)informationFlow;
            ret.add(CapellaEntityHelper.communicationMeanToTableLine(projectName, outputFolder, communicationMean, false));
        }
        return ret;
    }

    public static Collection<String> getOutgoingCommunicationMeansLines(Entity entity, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractInformationFlow informationFlow : entity.getOutgoingInformationFlows()) {
            if (!(informationFlow instanceof CommunicationMean)) continue;
            CommunicationMean communicationMean = (CommunicationMean)informationFlow;
            ret.add(CapellaEntityHelper.communicationMeanToTableLine(projectName, outputFolder, communicationMean, true));
        }
        return ret;
    }

    private static String communicationMeanToTableLine(String projectName, String outputFolder, CommunicationMean communicationMean, boolean isOut) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr>");
        buffer.append("<td id=\"" + CapellaServices.getAnchorId((EObject)communicationMean) + "\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)communicationMean, projectName, outputFolder));
        buffer.append(" ");
        buffer.append(communicationMean.getName());
        buffer.append("</td>");
        buffer.append("<td>");
        InformationsExchanger informationsExchanger = isOut ? communicationMean.getTarget() : communicationMean.getSource();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)informationsExchanger, projectName, outputFolder));
        buffer.append("&nbsp;");
        buffer.append(CapellaServices.getHyperlinkFromElement((EObject)informationsExchanger));
        buffer.append("</td>");
        buffer.append("<td>");
        buffer.append(StringUtil.transformAREFString((EObject)communicationMean, communicationMean.getDescription(), projectName, outputFolder));
        buffer.append("</td>");
        buffer.append("<td>");
        Collection<String> functionalExchanges = CapellaEntityHelper.getFunctionalExchanges(communicationMean, projectName, outputFolder);
        if (functionalExchanges.size() > 0) {
            buffer.append(StringUtil.stringListToBulette(functionalExchanges));
        }
        buffer.append("</td>");
        return buffer.toString();
    }

    private static Collection<String> getFunctionalExchanges(CommunicationMean communicationMean, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (FunctionalExchange functionalExchange : communicationMean.getAllocatedFunctionalExchanges()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)functionalExchange, projectName, outputFolder));
            buffer.append("&nbsp;");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)functionalExchange.getSource()));
            ret.add(buffer.toString());
        }
        return ret;
    }
}

