/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.dsl.provider.TextualScenarioProvider;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.DiagramToXtextCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class HelperCommands {
    public static final String DIALOG_TITLE_UNABLE_TO_REFRESH = "Unable to refresh";
    public static final String DIALOG_MESSAGE_ERROR_REFRESH = "Error on refreshing data to Textual Editor!";
    public static final String DIALOG_TITLE_UNABLE_TO_SAVE = "Unable to save";
    public static final String DIALOG_MESSAGE_ERROR_SAVE = "Error on saving data to diagram!";

    public static String getExpressionText(InteractionOperand operand) {
        Constraint guard = operand.getGuard();
        if (guard != null) {
            OpaqueExpression expression = (OpaqueExpression)guard.getOwnedSpecification();
            return expression.getBodies().isEmpty() ? null : (String)expression.getBodies().get(0);
        }
        return null;
    }

    public static List<Issue> getValidationIsuesTextResource(XtextResource resource) {
        IResourceValidator validator = resource.getResourceServiceProvider().getResourceValidator();
        if (validator != null) {
            return validator.validate((Resource)resource, CheckMode.ALL, null);
        }
        return new ArrayList<Issue>();
    }

    public static String getFormattedIssues(List<Issue> issues) {
        StringBuilder sb = new StringBuilder();
        String newLine = "\r\n";
        int maxDisplay = 3;
        sb.append(String.valueOf(newLine) + newLine + "Found " + issues.size() + " issues:" + newLine);
        int i = 0;
        while (i < maxDisplay && i < issues.size()) {
            Issue issue = issues.get(i);
            sb.append(String.valueOf(issue.getMessage()) + " (line : " + issue.getLineNumber() + " column : " + issue.getColumn() + ")" + newLine);
            ++i;
        }
        if (issues.size() > maxDisplay) {
            sb.append(String.valueOf(newLine) + "... " + (issues.size() - maxDisplay) + " more!" + newLine);
        }
        return sb.toString();
    }

    public static Model getModel(EmbeddedEditorView embeddedEditorViewPart) {
        TextualScenarioProvider p = embeddedEditorViewPart.getProvider();
        XtextResource resource = p.getResource();
        Model domainModel = null;
        if (resource != null) {
            EmbeddedEditorInstanceHelper.updateModel((String)"scenario {}");
            EList content1 = resource.getContents();
            if (!content1.isEmpty() && content1.get(0) instanceof Model) {
                domainModel = (Model)resource.getContents().get(0);
            }
        }
        return domainModel;
    }

    public static void clearModel(Model domainModel) {
        if (domainModel != null && domainModel.getParticipants() != null) {
            domainModel.getParticipants().clear();
        }
        if (domainModel != null && domainModel.getElements() != null) {
            domainModel.getElements().clear();
        }
        if (domainModel != null) {
            domainModel.setBegin("{");
            domainModel.setEnd("}");
        }
    }

    public static void showDialogTextualEditor(String title, String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
    }

    public static void refreshTextEditor(EmbeddedEditorView eeView) {
        DDiagram diagram = EmbeddedEditorInstance.getDDiagram();
        if (diagram != null) {
            Scenario scenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
            if (scenario != null) {
                DiagramToXtextCommands.process(scenario, eeView);
                eeView.refreshTitleBar(scenario.getName());
            }
        } else {
            eeView.refreshTitleBar("Textual Editor");
            EmbeddedEditorInstanceHelper.cleanUpModel();
        }
    }
}

