/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.dsl.ui.contentassist;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.scenario.editor.dsl.helpers.TextualScenarioHelper;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ArmTimerMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CombinedFragment;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.CreateMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.DeleteMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Element;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.FoundMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.LostMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Model;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Participant;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.ParticipantDeactivation;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.Reference;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessage;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.SequenceMessageType;
import org.polarsys.capella.scenario.editor.dsl.textualScenario.StateFragment;
import org.polarsys.capella.scenario.editor.dsl.ui.contentassist.AbstractTextualScenarioProposalProvider;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class TextualScenarioProposalProvider
extends AbstractTextualScenarioProposalProvider {
    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        boolean _isParticipantKeyword = TextualScenarioHelper.isParticipantKeyword((String)keyword.getValue());
        if (_isParticipantKeyword) {
            boolean _checkValidKeyword = EmbeddedEditorInstanceHelper.checkValidKeyword((String)keyword.getValue());
            if (_checkValidKeyword) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        } else {
            boolean _not;
            String[] messageKeywords = new String[]{"->", "->x", "->+", "->>", "->o", "o->"};
            boolean _contains = ((List)Conversions.doWrapArray((Object)messageKeywords)).contains(keyword.getValue());
            boolean bl = _not = !_contains;
            if (_not) {
                super.completeKeyword(keyword, contentAssistContext, acceptor);
            }
        }
    }

    @Override
    public void completeActor_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("actor", context, acceptor);
    }

    @Override
    public void completeComponent_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("component", context, acceptor);
    }

    @Override
    public void completeConfigurationItem_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("configuration_item", context, acceptor);
    }

    @Override
    public void completeFunction_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("function", context, acceptor);
    }

    @Override
    public void completeActivity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("activity", context, acceptor);
    }

    @Override
    public void completeEntity_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("entity", context, acceptor);
    }

    @Override
    public void completeRole_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.getExistingParticipants("role", context, acceptor);
    }

    public void getExistingParticipants(String keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Collection _availableElements = EmbeddedEditorInstanceHelper.getAvailableElements((String)keyword);
        for (EObject el : _availableElements) {
            boolean _not;
            String elementName = CapellaElementExt.getName((EObject)el);
            EObject _rootModel = context.getRootModel();
            boolean _participantAlreadyInserted = this.participantAlreadyInserted((Model)_rootModel, elementName, keyword);
            boolean bl = _not = !_participantAlreadyInserted;
            if (!_not) continue;
            ICompletionProposal _createCompletionProposal = this.createCompletionProposal("\"" + elementName + "\"", elementName, null, context);
            ConfigurableCompletionProposal proposal = (ConfigurableCompletionProposal)_createCompletionProposal;
            acceptor.accept((ICompletionProposal)proposal);
        }
    }

    public boolean participantAlreadyInserted(Model model, String name, String keyword) {
        EList _participants = model.getParticipants();
        for (Participant participant : _participants) {
            if (!Objects.equal((Object)participant.getKeyword(), (Object)keyword) || !Objects.equal((Object)participant.getName(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void completeSequenceMessage_Source(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeParticipants(context, acceptor);
    }

    @Override
    public void completeSequenceMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept(this.createCompletionProposal("->", "-> : Sequence Message", null, context));
    }

    @Override
    public void completeSequenceMessage_Target(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeParticipants(context, acceptor);
    }

    @Override
    public void completeSequenceMessage_Name(EObject messageObj, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        SequenceMessage message = (SequenceMessage)messageObj;
        this.createMessageProposal(message.getSource(), message.getTarget(), context, acceptor);
    }

    public void createMessageProposal(String source, String target, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _rootModel = context.getRootModel();
        Object scenarioExchangesType = TextualScenarioHelper.getScenarioAllowedExchangesType((EList)((Model)_rootModel).getElements());
        List exchangesAvailable = EmbeddedEditorInstanceHelper.getExchangeMessages((String)source, (String)target);
        String elementName = new String();
        for (EObject element : exchangesAvailable) {
            EObject _rootModel_1 = context.getRootModel();
            ((Model)_rootModel_1).getElements();
            boolean _isInterfaceScenario = EmbeddedEditorInstanceHelper.isInterfaceScenario();
            elementName = _isInterfaceScenario ? CapellaElementExt.getName((EObject)((ExchangeItemAllocation)element).getAllocatedItem()) : CapellaElementExt.getName((EObject)element);
            String exchangeType = TextualScenarioHelper.getExchangeType((EObject)element);
            if (scenarioExchangesType != null && !scenarioExchangesType.equals(exchangeType)) continue;
            String message = elementName;
            if (EmbeddedEditorInstanceHelper.isESScenario() && element instanceof FunctionalExchange) {
                String _plus_3;
                String _sourceFunctionNameOfExchange = EmbeddedEditorInstanceHelper.getSourceFunctionNameOfExchange((FunctionalExchange)((FunctionalExchange)element));
                String _plus = String.valueOf(message) + " : FE [ " + _sourceFunctionNameOfExchange;
                String _plus_1 = String.valueOf(_plus) + " ,";
                String _targetFunctionNameOfExchange = EmbeddedEditorInstanceHelper.getTargetFunctionNameOfExchange((FunctionalExchange)((FunctionalExchange)element));
                String _plus_2 = String.valueOf(_plus_1) + _targetFunctionNameOfExchange;
                message = _plus_3 = String.valueOf(_plus_2) + " ]";
            }
            acceptor.accept(this.createCompletionProposal("\"" + elementName + "\"", message, null, context));
        }
    }

    @Override
    public void completeCreateMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!EmbeddedEditorInstanceHelper.isFSScenario() && !EmbeddedEditorInstanceHelper.isESScenario()) {
            acceptor.accept(this.createCompletionProposal("->+", "->+ : Create Message", null, context));
        }
        if (EmbeddedEditorInstanceHelper.isInteractionScenario() && !EmbeddedEditorInstanceHelper.isFSScenario()) {
            acceptor.accept(this.createCompletionProposal("->+", "->+ : Create Message", null, context));
        }
    }

    @Override
    public void completeCreateMessage_Target(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String source = ((CreateMessage)model).getSource();
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            boolean _not;
            boolean _equals = ((Participant)el).getName().equals(source);
            boolean bl = _not = !_equals;
            if (!_not) continue;
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }

    @Override
    public void completeCreateMessage_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeCreateDeleteMessageName(model, context, acceptor);
    }

    @Override
    public void completeDeleteMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!EmbeddedEditorInstanceHelper.isFSScenario() && !EmbeddedEditorInstanceHelper.isESScenario()) {
            acceptor.accept(this.createCompletionProposal("->x", "->x : Delete Message", null, context));
        }
        if (EmbeddedEditorInstanceHelper.isInteractionScenario() && !EmbeddedEditorInstanceHelper.isFSScenario()) {
            acceptor.accept(this.createCompletionProposal("->x", "->x : Delete Message", null, context));
        }
    }

    @Override
    public void completeDeleteMessage_Target(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String source = ((DeleteMessage)model).getSource();
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            boolean _not;
            boolean _equals = ((Participant)el).getName().equals(source);
            boolean bl = _not = !_equals;
            if (!_not) continue;
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }

    @Override
    public void completeParticipantDeactivation_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject modelContainer = TextualScenarioHelper.getModelContainer((EObject)((ParticipantDeactivation)model));
        HashMap<String, Integer> timelinesToPropose = new HashMap<String, Integer>();
        ArrayList _arrayList = new ArrayList();
        this.createTimelinesHashMapToProposeForDeactivation((ParticipantDeactivation)model, TextualScenarioHelper.getAllElements((EObject)modelContainer, _arrayList), timelinesToPropose);
        Set<String> _keySet = timelinesToPropose.keySet();
        for (String timelineToPropose : _keySet) {
            boolean _greaterEqualsThan;
            Integer _get = timelinesToPropose.get(timelineToPropose);
            boolean bl = _greaterEqualsThan = _get >= 1;
            if (!_greaterEqualsThan) continue;
            acceptor.accept(this.createCompletionProposal("\"" + timelineToPropose + "\"", timelineToPropose, null, context));
        }
    }

    public HashMap<String, Integer> createTimelinesHashMapToProposeForDeactivation(ParticipantDeactivation participantDeactivation, List<Element> elements, HashMap<String, Integer> timelinesToPropose) {
        int i = 0;
        while (i < elements.size()) {
            boolean _equals = elements.get(i).equals(participantDeactivation);
            if (_equals) {
                int j = 0;
                while (j <= i) {
                    this.updateHashMap(timelinesToPropose, (EObject)elements.get(j), participantDeactivation);
                    ++j;
                }
                return timelinesToPropose;
            }
            ++i;
        }
        return timelinesToPropose;
    }

    public Integer updateHashMap(HashMap<String, Integer> timelinesToPropose, EObject element, ParticipantDeactivation participantDeactivation) {
        Integer _xblockexpression = null;
        if (element instanceof SequenceMessage) {
            this.updateHashMapWithSequenceMessage(timelinesToPropose, (SequenceMessage)element);
        }
        if (element instanceof ArmTimerMessage) {
            this.updateHashMapWithArmTimerMessage(timelinesToPropose, (ArmTimerMessage)element);
        }
        if (element instanceof FoundMessage) {
            this.updateHashMapWithFoundMessage(timelinesToPropose, (FoundMessage)element);
        }
        Integer _xifexpression = null;
        if (element instanceof ParticipantDeactivation) {
            _xifexpression = this.updateHashMapWithParticipantDeactivation(timelinesToPropose, (ParticipantDeactivation)element);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public Integer updateHashMapWithSequenceMessage(HashMap<String, Integer> timelinesToPropose, SequenceMessage sequenceMessage) {
        boolean _tripleNotEquals;
        Integer _xifexpression = null;
        String _execution = sequenceMessage.getExecution();
        boolean bl = _tripleNotEquals = _execution != null;
        if (_tripleNotEquals) {
            Integer _xifexpression_1 = null;
            boolean _containsKey = timelinesToPropose.containsKey(sequenceMessage.getTarget());
            if (_containsKey) {
                Integer _xblockexpression = null;
                Integer value = timelinesToPropose.get(sequenceMessage.getTarget());
                _xifexpression_1 = _xblockexpression = timelinesToPropose.put(sequenceMessage.getTarget(), value + 1);
            } else {
                _xifexpression_1 = timelinesToPropose.put(sequenceMessage.getTarget(), 1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public Integer updateHashMapWithArmTimerMessage(HashMap<String, Integer> timelinesToPropose, ArmTimerMessage armTimer) {
        boolean _tripleNotEquals;
        Integer _xifexpression = null;
        String _execution = armTimer.getExecution();
        boolean bl = _tripleNotEquals = _execution != null;
        if (_tripleNotEquals) {
            Integer _xifexpression_1 = null;
            boolean _containsKey = timelinesToPropose.containsKey(armTimer.getParticipant());
            if (_containsKey) {
                Integer _xblockexpression = null;
                Integer value = timelinesToPropose.get(armTimer.getParticipant());
                _xifexpression_1 = _xblockexpression = (value = Integer.valueOf(value + 1));
            } else {
                _xifexpression_1 = timelinesToPropose.put(armTimer.getParticipant(), 1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public Integer updateHashMapWithFoundMessage(HashMap<String, Integer> timelinesToPropose, FoundMessage foundMessage) {
        boolean _tripleNotEquals;
        Integer _xifexpression = null;
        String _execution = foundMessage.getExecution();
        boolean bl = _tripleNotEquals = _execution != null;
        if (_tripleNotEquals) {
            Integer _xifexpression_1 = null;
            boolean _containsKey = timelinesToPropose.containsKey(foundMessage.getTarget());
            if (_containsKey) {
                Integer _xblockexpression = null;
                Integer value = timelinesToPropose.get(foundMessage.getTarget());
                _xifexpression_1 = _xblockexpression = (value = Integer.valueOf(value + 1));
            } else {
                _xifexpression_1 = timelinesToPropose.put(foundMessage.getTarget(), 1);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public Integer updateHashMapWithParticipantDeactivation(HashMap<String, Integer> timelinesToPropose, ParticipantDeactivation participantDeactivation) {
        Integer _xifexpression = null;
        boolean _containsKey = timelinesToPropose.containsKey(participantDeactivation.getName());
        if (_containsKey) {
            Integer _xblockexpression = null;
            Integer value = timelinesToPropose.get(participantDeactivation.getName());
            _xifexpression = _xblockexpression = timelinesToPropose.put(participantDeactivation.getName(), value - 1);
        }
        return _xifexpression;
    }

    @Override
    public void completeDeleteMessage_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeCreateDeleteMessageName(model, context, acceptor);
    }

    @Override
    public void completeArmTimerMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        boolean _isFSScenario = EmbeddedEditorInstanceHelper.isFSScenario();
        boolean bl = _not = !_isFSScenario;
        if (_not) {
            acceptor.accept(this.createCompletionProposal("->>", "->> : Arm Timer", null, context));
        }
    }

    @Override
    public void completeArmTimerMessage_Participant(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeParticipants(context, acceptor);
    }

    @Override
    public void completeArmTimerMessage_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept(this.createCompletionProposal("\"Arm Timer\"", "\"Arm Timer\"", null, context));
    }

    @Override
    public void completeLostMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        if (_isESScenario) {
            acceptor.accept(this.createCompletionProposal("->o", "->o : Lost Message", null, context));
        }
    }

    @Override
    public void completeLostMessage_Source(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeParticipants(context, acceptor);
    }

    @Override
    public void completeLostMessage_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        LostMessage message = (LostMessage)model;
        this.createMessageProposal(message.getSource(), null, context, acceptor);
    }

    @Override
    public void completeFoundMessage_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        FoundMessage message = (FoundMessage)model;
        this.createMessageProposal(null, message.getTarget(), context, acceptor);
    }

    @Override
    public void completeFoundMessage_Arrow(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _isESScenario = EmbeddedEditorInstanceHelper.isESScenario();
        if (_isESScenario) {
            acceptor.accept(this.createCompletionProposal("o->", "o-> : Found Message", null, context));
        }
    }

    @Override
    public void completeFoundMessage_Target(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeParticipants(context, acceptor);
    }

    @Override
    public void completeStateFragment_Timeline(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }

    @Override
    public void completeStateFragment_Keyword(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList keywords = CollectionLiterals.newArrayList((Object[])new String[]{"state", "mode"});
        String scenarioType = EmbeddedEditorInstanceHelper.getScenarioType();
        EObject scenarioLevel = EmbeddedEditorInstanceHelper.getScenarioLevel();
        if (!scenarioType.equals("FUNCTIONAL") && !(scenarioLevel instanceof EPBSArchitecture)) {
            keywords.add("function");
        }
        for (String keyword : keywords) {
            acceptor.accept(this.createCompletionProposal(keyword, keyword, null, context));
        }
    }

    @Override
    public void completeStateFragment_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List _availableStateFragments = EmbeddedEditorInstanceHelper.getAvailableStateFragments((String)((StateFragment)model).getKeyword(), (String)((StateFragment)model).getTimeline());
        for (String stateFragment : _availableStateFragments) {
            acceptor.accept(this.createCompletionProposal("\"" + stateFragment + "\"", stateFragment, null, context));
        }
    }

    @Override
    public void completeCombinedFragment_Timelines(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            boolean _not;
            boolean _contains = ((CombinedFragment)model).getTimelines().contains((Object)((Participant)el).getName());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }

    @Override
    public void completeReference_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List referencedScenarios = EmbeddedEditorInstanceHelper.getReferencedScenariosName();
        for (String referencedScenario : referencedScenarios) {
            acceptor.accept(this.createCompletionProposal("\"" + referencedScenario + "\"", referencedScenario, null, context));
        }
    }

    @Override
    public void completeReference_Timelines(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            boolean _not;
            if (!(model instanceof Reference)) continue;
            boolean _contains = ((Reference)model).getTimelines().contains((Object)((Participant)el).getName());
            boolean bl = _not = !_contains;
            if (!_not) continue;
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }

    public boolean messageAlreadyInserted(Model model, String source, String target, String name) {
        EList _elements = model.getElements();
        for (Element element : _elements) {
            SequenceMessage message;
            if (!(element instanceof SequenceMessage) || !Objects.equal((Object)(message = (SequenceMessage)element).getName(), (Object)name) || !Objects.equal((Object)message.getSource(), (Object)source) || !Objects.equal((Object)message.getTarget(), (Object)target)) continue;
            return true;
        }
        return false;
    }

    public void completeCreateDeleteMessageName(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        SequenceMessageType message = (SequenceMessageType)model;
        List exchangesAvailable = EmbeddedEditorInstanceHelper.getExchangeMessages((String)message.getSource(), (String)message.getTarget());
        String elementName = new String();
        for (EObject element : exchangesAvailable) {
            boolean _isInterfaceScenario = EmbeddedEditorInstanceHelper.isInterfaceScenario();
            elementName = _isInterfaceScenario ? CapellaElementExt.getName((EObject)((ExchangeItemAllocation)element).getAllocatedItem()) : CapellaElementExt.getName((EObject)element);
            if (elementName == null) continue;
            acceptor.accept(this.createCompletionProposal("\"" + elementName + "\"", elementName, null, context));
        }
    }

    public void proposeParticipants(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject _rootModel = context.getRootModel();
        EList _participantsDefinedBefore = TextualScenarioHelper.participantsDefinedBefore((Model)((Model)_rootModel));
        for (EObject el : _participantsDefinedBefore) {
            String _name = ((Participant)el).getName();
            String _plus = "\"" + _name;
            String _plus_1 = String.valueOf(_plus) + "\"";
            acceptor.accept(this.createCompletionProposal(_plus_1, ((Participant)el).getName(), null, context));
        }
    }
}

