/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.multiphases;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;

public class ReferenceScopeTest {
    public Collection<Object> getActualReferenceScope() {
        return null;
    }

    public <T> Collection<T> getActualReferenceScope(Class<T> clazz) {
        return Collections2.filter(this.getActualReferenceScope(), (Predicate)Predicates.instanceOf(clazz));
    }

    private Object[] getSelectedNodePhysicalComponents() {
        return new EObject[0];
    }

    @Test
    public void selectedNodePhysicalComponents() {
        Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItems((Object[])this.getSelectedNodePhysicalComponents()));
    }

    @Test
    public void childPhysicalComponents() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            for (Object child : pc.getOwnedPhysicalComponents()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(child));
            }
        }
    }

    @Test
    public void deployedPhysicalComponents() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            for (Object deployed : pc.getDeployedPhysicalComponents()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(deployed));
            }
        }
    }

    @Test
    public void allocatedPhysicalFunctions() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            for (Object allocatedFunction : pc.getAllocatedPhysicalFunctions()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(allocatedFunction));
            }
        }
    }

    @Test
    public void physicalPorts() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            for (Object physicalPort : pc.getContainedPhysicalPorts()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(physicalPort));
            }
        }
    }

    @Test
    public void physicalLinks() {
        for (PhysicalPort port : this.getActualReferenceScope(PhysicalPort.class)) {
            for (Object physicalLink : port.getInvolvedLinks()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(physicalLink));
            }
        }
    }

    @Test
    public void physicalLinkCategory() {
        for (PhysicalLink link : this.getActualReferenceScope(PhysicalLink.class)) {
            for (Object category : link.getCategories()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(category));
            }
        }
    }

    @Test
    public void componentPorts() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            for (Object cp : pc.getContainedComponentPorts()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(cp));
            }
        }
    }

    @Test
    public void componentExchange() {
        for (ComponentPort cp : this.getActualReferenceScope(ComponentPort.class)) {
            for (Object ce : cp.getComponentExchanges()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(ce));
            }
        }
    }

    @Test
    public void behaviourComponentImplementedAndUsedInterfaces() {
        for (PhysicalComponent pc : this.getActualReferenceScope(PhysicalComponent.class)) {
            if (pc.getNature() != PhysicalComponentNature.BEHAVIOR) continue;
            for (Object implementedInterface : pc.getImplementedInterfaces()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(implementedInterface));
            }
            for (Object usedInterface : pc.getUsedInterfaces()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(usedInterface));
            }
        }
    }

    @Test
    public void componentPortRequiredAndProvidedInterfaces() {
        for (ComponentPort cp : this.getActualReferenceScope(ComponentPort.class)) {
            for (Object requiredInterface : cp.getRequiredInterfaces()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(requiredInterface));
            }
            for (Object providedInterface : cp.getProvidedInterfaces()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(providedInterface));
            }
        }
    }

    public void interfaceExchangeItems() {
        for (Interface iface : this.getActualReferenceScope(Interface.class)) {
            for (Object exchangeItem : iface.getExchangeItems()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(exchangeItem));
            }
        }
    }

    @Test
    public void exchangeItemElements() {
        for (ExchangeItem ei : this.getActualReferenceScope(ExchangeItem.class)) {
            for (Object exchangeItemElement : ei.getOwnedElements()) {
                Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem(exchangeItemElement));
            }
        }
    }

    @Test
    public void exchangeItemElementType() {
        for (ExchangeItemElement eie : this.getActualReferenceScope(ExchangeItemElement.class)) {
            Assert.assertThat(this.getActualReferenceScope(), (Matcher)JUnitMatchers.hasItem((Object)eie.getType()));
        }
    }

    private Predicate<? super EObject> isNodePhysicalComponent() {
        return new Predicate<EObject>(){

            public boolean apply(EObject arg0) {
                return arg0 instanceof PhysicalComponent && ((PhysicalComponent)arg0).getNature() == PhysicalComponentNature.NODE;
            }
        };
    }

    private Predicate<? super EObject> isBehaviorPhysicalComponent() {
        return new Predicate<EObject>(){

            public boolean apply(EObject arg0) {
                return arg0 instanceof PhysicalComponent && ((PhysicalComponent)arg0).getNature() == PhysicalComponentNature.BEHAVIOR;
            }
        };
    }
}

