/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.attachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.IContextScopeHandler;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyChangeEvent;
import org.polarsys.capella.core.transition.common.handlers.notify.INotifyListener;
import org.polarsys.capella.core.transition.common.handlers.notify.NotifyHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.ScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.SubSets;
import org.polarsys.capella.transition.system2subsystem.handlers.scope.ExternalFunctionsScopeRetriever;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class FunctionalChainAttachmentHelper
implements IHandler,
INotifyListener {
    protected static final String FUNCTIONAL_CHAIN_ATTACHMENT_MAP = "FCAttachmentMap";
    protected static final String MERGE_MAP = "MERGE_MAP";

    public static FunctionalChainAttachmentHelper getInstance(IContext context_p) {
        FunctionalChainAttachmentHelper handler = (FunctionalChainAttachmentHelper)context_p.get((Object)"FCAttachment");
        if (handler == null) {
            handler = new FunctionalChainAttachmentHelper();
            handler.init(context_p);
            context_p.put((Object)"FCAttachment", (Object)handler);
        }
        return handler;
    }

    public Boolean isValidElement(EObject source, IContext context_p) {
        Boolean cache = this.getValidityMap(context_p).get(source);
        if (cache == null) {
            cache = Boolean.FALSE;
        }
        return cache;
    }

    public void setValidElement(EObject source, Boolean target, IContext context_p) {
        this.getValidityMap(context_p).put(source, target);
    }

    protected SubSets<FunctionalChainInvolvementFunction> getMergeSets(IContext context_p) {
        SubSets res = (SubSets)context_p.get((Object)MERGE_MAP);
        if (res == null) {
            res = new SubSets();
            context_p.put((Object)MERGE_MAP, res);
        }
        return res;
    }

    protected Map<EObject, Boolean> getValidityMap(IContext context_p) {
        HashMap res = (HashMap)context_p.get((Object)FUNCTIONAL_CHAIN_ATTACHMENT_MAP);
        if (res == null) {
            res = new HashMap();
            context_p.put((Object)FUNCTIONAL_CHAIN_ATTACHMENT_MAP, res);
        }
        return res;
    }

    public IStatus init(IContext context_p) {
        NotifyHandlerHelper.getInstance((IContext)context_p).addListener("NOTIFY__END_TRANSFORMATION", (INotifyListener)this, context_p);
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public boolean isValidInvolvement(FunctionalChainInvolvement element_p, IContext context_p) {
        FunctionalChainInvolvement nextFCI;
        boolean nextInScope;
        boolean inScope;
        IContextScopeHandler scope = ContextScopeHandlerHelper.getInstance((IContext)context_p);
        NamedElement involvedElement = (NamedElement)element_p.getInvolved();
        IStatus willBeTransformed = TransformationHandlerHelper.getInstance((IContext)context_p).isOrWillBeTransformed((EObject)involvedElement, context_p);
        if (involvedElement instanceof AbstractFunction) {
            inScope = ExternalFunctionsScopeRetriever.isPrimaryFunction((AbstractFunction)involvedElement, context_p);
        } else {
            boolean bl = inScope = !scope.contains("scope_secondary_element", (EObject)involvedElement, context_p) && ScopeHandlerHelper.getInstance((IContext)context_p).isInScope((EObject)involvedElement, context_p);
        }
        if (involvedElement instanceof FunctionalExchange && inScope && !element_p.getNextFunctionalChainInvolvements().isEmpty() && !(nextInScope = this.isValidInvolvement(nextFCI = (FunctionalChainInvolvement)element_p.getNextFunctionalChainInvolvements().get(0), context_p))) {
            return false;
        }
        if (!inScope) {
            if (involvedElement instanceof AbstractFunction) {
                inScope = ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction((AbstractFunction)involvedElement, context_p);
            } else if (involvedElement instanceof FunctionalExchange) {
                boolean prevScoped = false;
                boolean nextScoped = false;
                for (FunctionalChainInvolvement n : element_p.getNextFunctionalChainInvolvements()) {
                    if (!ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction((AbstractFunction)n.getInvolved(), context_p)) continue;
                    nextScoped = true;
                    break;
                }
                for (FunctionalChainInvolvement p : element_p.getPreviousFunctionalChainInvolvements()) {
                    if (!ExternalFunctionsScopeRetriever.isLinkToPrimaryFunction((AbstractFunction)p.getInvolved(), context_p)) continue;
                    prevScoped = true;
                    break;
                }
                if (prevScoped && nextScoped) {
                    inScope = true;
                }
            }
        }
        return inScope && willBeTransformed.isOK();
    }

    public void computeChain(FunctionalChain element_p, IContext context_p) {
        for (FunctionalChainInvolvement next : element_p.getFirstFunctionalChainInvolvements()) {
            this.computeChainInternal(next, context_p, null);
        }
    }

    public void computeChainInternal(FunctionalChainInvolvement involmt, IContext context_p, FunctionalChainInvolvement lastValid) {
        if (this.getValidityMap(context_p).get(involmt) != null) {
            return;
        }
        boolean isValid = this.isValidInvolvement(involmt, context_p);
        this.setValidElement((EObject)involmt, isValid, context_p);
        if (isValid) {
            lastValid = involmt;
        }
        try {
            for (FunctionalChainInvolvement next : involmt.getNextFunctionalChainInvolvements()) {
                this.computeChainInternal(next, context_p, lastValid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection<FunctionalChainInvolvement> getNextValid(FunctionalChainInvolvement fci, IContext context_p) {
        ArrayList<FunctionalChainInvolvement> res = new ArrayList<FunctionalChainInvolvement>();
        this.getNextValidInternal(fci, fci, context_p, res);
        return res;
    }

    private void getNextValidInternal(FunctionalChainInvolvement fci, FunctionalChainInvolvement sc, IContext context_p, Collection<FunctionalChainInvolvement> res) {
        if (fci.getNextFunctionalChainInvolvements() != null && !fci.getNextFunctionalChainInvolvements().isEmpty()) {
            for (FunctionalChainInvolvement next : fci.getNextFunctionalChainInvolvements()) {
                if (next == null) continue;
                if (this.isValidElement((EObject)next, context_p).booleanValue()) {
                    res.add(next);
                    continue;
                }
                this.getNextValidInternal(next, sc, context_p, res);
            }
        }
    }

    public Collection<FunctionalChainInvolvement> getPreviousValid(FunctionalChainInvolvement fci, IContext context_p) {
        ArrayList<FunctionalChainInvolvement> res = new ArrayList<FunctionalChainInvolvement>();
        this.getPreviousValidInternal(fci, context_p, res);
        return res;
    }

    private void getPreviousValidInternal(FunctionalChainInvolvement fci, IContext context_p, Collection<FunctionalChainInvolvement> res) {
        if (fci.getPreviousFunctionalChainInvolvements() != null && !fci.getPreviousFunctionalChainInvolvements().isEmpty()) {
            for (FunctionalChainInvolvement prev : fci.getPreviousFunctionalChainInvolvements()) {
                if (prev == null) continue;
                if (this.isValidElement((EObject)prev, context_p).booleanValue()) {
                    res.add(prev);
                    continue;
                }
                this.getPreviousValidInternal(prev, context_p, res);
            }
        }
    }

    public void merge(FunctionalChainInvolvementFunction tSrc, FunctionalChainInvolvementFunction tTgt, IContext context) {
        this.getMergeSets(context).merge(tSrc, tTgt);
    }

    public void notifyChanged(INotifyChangeEvent event, IContext context) {
        for (Collection collection : this.getMergeSets(context).getSets()) {
            FunctionalChainInvolvementFunction[] array = collection.toArray(new FunctionalChainInvolvementFunction[0]);
            int i = 1;
            while (i < array.length) {
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT_LINK__SOURCE)) {
                    ((FunctionalChainInvolvementLink)o).setSource(array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT_LINK__TARGET)) {
                    ((FunctionalChainInvolvementLink)o).setTarget(array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.SEQUENCE_LINK__SOURCE)) {
                    ((SequenceLink)o).setSource((SequenceLinkEnd)array[0]);
                }
                for (EObject o : EObjectExt.getReferencers((EObject)array[i], (EReference)FaPackage.Literals.SEQUENCE_LINK__TARGET)) {
                    ((SequenceLink)o).setTarget((SequenceLinkEnd)array[0]);
                }
                ++i;
            }
        }
    }
}

