/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.launcher;

import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.transition.common.activities.DifferencesMergingActivity;
import org.polarsys.capella.core.transition.common.activities.FinalizeTransitionActivity;
import org.polarsys.capella.core.transition.common.activities.InitializeScopeActivity;
import org.polarsys.capella.core.transition.common.activities.PostTransformationActivity;
import org.polarsys.capella.core.transition.common.handlers.options.DefaultOptionsHandler;
import org.polarsys.capella.core.transition.common.handlers.options.IOptionsHandler;
import org.polarsys.capella.core.transition.common.transposer.ExtendedRulesHandler;
import org.polarsys.capella.transition.system2subsystem.activities.FinalizeSubsystemTransitionActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.InitializeMultiphasesDiffMergeActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.InitializeMultiphasesTransformationActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.InitializeMultiphasesTransitionActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.JustificationLinkPass;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.MultiphasesDifferencesComputingActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.MultiphasesDifferencesFilteringActivity;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.RealizationLinkPass;
import org.polarsys.capella.transition.system2subsystem.multiphases.activities.RootComponentNameUpdater;
import org.polarsys.capella.transition.system2subsystem.multiphases.handlers.attachment.LAAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.multiphases.handlers.attachment.PAAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.multiphases.handlers.attachment.SAAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.multiphases.launcher.AbstractHeadlessMultiphasesLauncher;
import org.polarsys.capella.transition.system2subsystem.multiphases.launcher.LostAndFoundPass;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.mappings.purposes.NonExistingPurposeException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class HeadlessMultiphasesLauncher {
    private final IOptionsHandler optionsHandler;
    private final boolean merge;
    private final Collection<GenericParameter<?>> headlessParameters;
    private final Logger logger;

    public HeadlessMultiphasesLauncher(IOptionsHandler optionsHandler, Collection<GenericParameter<?>> headlessParameters, boolean merge) {
        this.optionsHandler = optionsHandler;
        this.headlessParameters = headlessParameters;
        this.merge = merge;
        this.logger = ReportManagerRegistry.getInstance().subscribe("Default");
    }

    public HeadlessMultiphasesLauncher(Collection<GenericParameter<?>> headlessParameters, boolean merge) {
        this((IOptionsHandler)new DefaultOptionsHandler(), headlessParameters, merge);
    }

    public HeadlessMultiphasesLauncher(Collection<GenericParameter<?>> headlessParameters) {
        this(headlessParameters, true);
    }

    public void launch(Collection<Object> selection, IProgressMonitor monitor) {
        MultiphasesContext context = new MultiphasesContext(selection);
        IStatus result = this.initializeMultiphasesTransition(context, this.optionsHandler);
        if (result.isOK()) {
            try {
                context.put("CrossPhasesAttachment", (Object)new SAAttachmentHelper());
                new SA_Launcher(context).run(selection, true, monitor);
                context.put("CrossPhasesAttachment", (Object)new LAAttachmentHelper());
                new LA_Launcher(context).run(selection, true, monitor);
                context.put("CrossPhasesAttachment", (Object)new PAAttachmentHelper());
                new PA_Launcher(context).run(selection, true, monitor);
                new LostAndFoundPass().attachLostAndFound(context);
                new RealizationLinkPass().createRealizationLinks(context.getTempSystemEngineering(), (IContext)context);
                ActivityParameters params = this.createPostTransformationParameters(context);
                new PostTransformationActivity().run(params);
                new JustificationLinkPass().createJustificationLinks((EObject)context.getTempSystemEngineering(), context.getSelectedPhysicalComponents());
                new RootComponentNameUpdater().updateRootComponentNames(context.getTempSystemEngineering(), context.getSelectedPhysicalComponents());
                if (this.merge) {
                    new InitializeMultiphasesDiffMergeActivity().run(params);
                    new MultiphasesDifferencesComputingActivity().run(params);
                    new MultiphasesDifferencesFilteringActivity().run(params);
                    new DifferencesMergingActivity().run(params);
                }
                new FinalizeTransitionActivity().run(params);
            }
            finally {
                try {
                    ActivityParameters params = new ActivityParameters();
                    params.addParameter(new GenericParameter("TransposerContext", (Object)context, null));
                    new FinalizeSubsystemTransitionActivity().run(params);
                }
                finally {
                    context.fullReset();
                }
            }
        }
        if (result == Status.CANCEL_STATUS) {
            this.logger.debug((Object)"Multiphase transition was cancelled");
        } else {
            this.logger.log((Priority)this.statusToLevel(result), (Object)result.getMessage());
        }
    }

    private Level statusToLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return Level.ERROR;
            }
            case 1: {
                return Level.INFO;
            }
            case 8: {
                return Level.DEBUG;
            }
            case 2: {
                return Level.WARN;
            }
        }
        return Level.ERROR;
    }

    protected ActivityParameters createPostTransformationParameters(MultiphasesContext context) {
        ActivityParameters params = new ActivityParameters();
        params.addParameter(new GenericParameter("TransposerContext", (Object)context, null));
        for (GenericParameter<?> paramHeadless : this.headlessParameters) {
            params.addParameter(paramHeadless);
        }
        return params;
    }

    protected ActivityParameters createPreTransformationParameters(MultiphasesContext context, IOptionsHandler optionsHandler) {
        ActivityParameters parameter = new ActivityParameters();
        parameter.addParameter(new GenericParameter("TransposerContext", (Object)context, null));
        parameter.addParameter(new GenericParameter("org.polarsys.capella.core.transition.ruleHandler", null, null));
        parameter.addParameter(new GenericParameter("_O__H", (Object)optionsHandler, "Transposer Options handler"));
        for (GenericParameter<?> paramHeadless : this.headlessParameters) {
            parameter.addParameter(paramHeadless);
        }
        return parameter;
    }

    private IStatus initializeMultiphasesTransition(MultiphasesContext context, IOptionsHandler optionsHandler) {
        ActivityParameters params;
        IStatus status;
        if (!this.merge) {
            context.put("DIFFMERGE_DISABLE", Boolean.TRUE);
        }
        if ((status = new InitializeMultiphasesTransitionActivity().run(params = this.createPreTransformationParameters(context, optionsHandler))).isOK()) {
            status = new InitializeMultiphasesTransformationActivity().run(params);
        }
        if (status.isOK()) {
            try {
                ExtendedRulesHandler handler = new ExtendedRulesHandler("org.polarsys.capella.core.transition", MultiphasesContext.Mapping.SA.getMappingId());
                context.put("_R_H", handler);
            }
            catch (NonExistingPurposeException e) {
                throw new IllegalStateException(e);
            }
            status = new InitializeScopeActivity().run(params);
        }
        return status;
    }

    protected class LA_Launcher
    extends AbstractHeadlessMultiphasesLauncher {
        public LA_Launcher(MultiphasesContext context) {
            super(context, MultiphasesContext.Mapping.LA, HeadlessMultiphasesLauncher.this.merge, HeadlessMultiphasesLauncher.this.headlessParameters);
        }
    }

    protected class PA_Launcher
    extends AbstractHeadlessMultiphasesLauncher {
        public PA_Launcher(MultiphasesContext context) {
            super(context, MultiphasesContext.Mapping.PA, HeadlessMultiphasesLauncher.this.merge, HeadlessMultiphasesLauncher.this.headlessParameters);
        }
    }

    protected class SA_Launcher
    extends AbstractHeadlessMultiphasesLauncher {
        public SA_Launcher(MultiphasesContext context) {
            super(context, MultiphasesContext.Mapping.SA, HeadlessMultiphasesLauncher.this.merge, HeadlessMultiphasesLauncher.this.headlessParameters);
        }
    }
}

