/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.activities;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.vp.requirements.importer.transposer.activities.Messages;
import org.polarsys.capella.vp.requirements.importer.transposer.activities.ReqIFJobSchedulingRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPBridge;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class TransposerTransformation
extends AbstractActivity {
    final boolean[] mergeOperationCanceled = new boolean[1];
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("Default");

    protected IStatus _run(ActivityParameters activityParams) {
        MergeAndSaveRequirementsUIJob job = new MergeAndSaveRequirementsUIJob(activityParams);
        job.setRule(ReqIFJobSchedulingRule.getInstance());
        job.setPriority(20);
        job.schedule();
        return Status.OK_STATUS;
    }

    protected IStatus mergeAndSave(ActivityParameters activityParams, IProgressMonitor monitor) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        if (this.reqIfContainsModule(context)) {
            IEditableModelScope targetScope;
            List targetScopeContents;
            BlockArchitecture blockArchitecture = (BlockArchitecture)context.get((Object)"TARGET_ELEMENT");
            RequirementsVPBridge requirementBridge = (RequirementsVPBridge)((Object)context.get((Object)"BRIDGE"));
            IIncrementalBridgeExecution requirementBridgeExecution = (IIncrementalBridgeExecution)context.get((Object)"BRIDGE_EXECUTION");
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)blockArchitecture);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Merge and Save requirements", (int)2);
            this.mergeRequirements(executionManager, requirementBridge, requirementBridgeExecution, subMonitor.split(1));
            if (!this.isMergeOperationCanceled() && !(targetScopeContents = (targetScope = (IEditableModelScope)context.get((Object)"TARGET_SCOPE")).getContents()).isEmpty()) {
                EObject rootScopeElement = (EObject)targetScopeContents.get(0);
                Resource modelResource = rootScopeElement.eResource();
                Resource traceResource = (Resource)context.get((Object)"TRACE_RESOURCE");
                this.saveAndCleanResources(executionManager, modelResource, traceResource, subMonitor.split(1));
                this.importReferencedImages((EObject)blockArchitecture, context);
            }
        } else {
            this.displayNoModuleFoundInformationDialog();
        }
        return Status.OK_STATUS;
    }

    protected void importReferencedImages(EObject targetElement, IContext context) {
        TreeIterator eAllContents = targetElement.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObj = (EObject)eAllContents.next();
            if (!(eObj instanceof Requirement)) continue;
            Requirement requirement = (Requirement)eObj;
            this.importReferencedImagesOfRequirement(requirement, context);
        }
    }

    protected void importReferencedImagesOfRequirement(Requirement requirement, IContext context) {
        List imagesToCopy;
        Map reqID2Images = (Map)context.get((Object)"Images to copy");
        if (reqID2Images.containsKey(requirement.getReqIFIdentifier()) && !(imagesToCopy = (List)reqID2Images.get(requirement.getReqIFIdentifier())).isEmpty()) {
            for (List srcPath2TargetPath : imagesToCopy) {
                try {
                    Files.copy((Path)srcPath2TargetPath.get(0), (Path)srcPath2TargetPath.get(1), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.log((Priority)Level.ERROR, (Object)MessageFormat.format("Cannot find or cannot copy {0}", srcPath2TargetPath.get(0)), (Throwable)e);
                }
            }
        }
    }

    private void mergeRequirements(ExecutionManager executionManager, final RequirementsVPBridge requirementBridge, final IIncrementalBridgeExecution requirementBridgeExecution, final SubMonitor monitor) {
        monitor.beginTask("Merge requirements", 1);
        this.setMergeOperationCanceled(false);
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                IStatus result = requirementBridge.mergeInteractively(requirementBridgeExecution, (IProgressMonitor)monitor);
                if (result == Status.CANCEL_STATUS) {
                    TransposerTransformation.this.setMergeOperationCanceled(true);
                    throw new OperationCanceledException(result.getMessage());
                }
            }
        });
    }

    private void saveAndCleanResources(ExecutionManager executionManager, final Resource modelResource, final Resource traceResource, final SubMonitor monitor) {
        executionManager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                TransposerTransformation.this.saveResources(modelResource, traceResource, monitor);
                HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((Resource)modelResource));
            }
        });
    }

    private void saveResources(Resource modelResource, Resource traceResource, SubMonitor progressMonitor) {
        IWorkspace workspace;
        IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
        if (workspaceRoot != null && (workspace = workspaceRoot.getWorkspace()) != null) {
            SaveResourcesWorkspaceRunnable saveRunnable = new SaveResourcesWorkspaceRunnable(modelResource, traceResource);
            try {
                workspace.run((IWorkspaceRunnable)saveRunnable, (IProgressMonitor)progressMonitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void displayNoModuleFoundInformationDialog() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String title = Messages.ReqIfImport_NoModuleFoundPopup_Title;
        String content = Messages.ReqIfImport_NoModuleFoundPopup_Content;
        MessageDialog.openInformation((Shell)shell, (String)title, (String)content);
    }

    private void setMergeOperationCanceled(boolean isCanceled) {
        this.mergeOperationCanceled[0] = isCanceled;
    }

    private boolean isMergeOperationCanceled() {
        return this.mergeOperationCanceled[0];
    }

    public static String getId() {
        return TransposerTransformation.class.getCanonicalName();
    }

    private boolean reqIfContainsModule(IContext context) {
        Object isModulePresent = context.get((Object)"ReqIF model must have at least a module");
        return isModulePresent instanceof Boolean && (Boolean)isModulePresent != false;
    }

    protected static void compact(Resource resource) {
        List filtered = EcoreUtil.filterDescendants((Collection)resource.getContents());
        resource.getContents().retainAll((Collection)filtered);
    }

    protected static void setTrace(final Resource traceResource, final IBridgeTrace trace) {
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                traceResource.getContents().clear();
                traceResource.getContents().add((Object)((EObject)trace));
            }
        });
    }

    private class MergeAndSaveRequirementsUIJob
    extends UIJob {
        private ActivityParameters activityParams;

        public MergeAndSaveRequirementsUIJob(ActivityParameters activityParams) {
            super("Import and Merge Requirements Job");
            this.activityParams = activityParams;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            return TransposerTransformation.this.mergeAndSave(this.activityParams, monitor);
        }
    }

    private class SaveResourcesWorkspaceRunnable
    implements IWorkspaceRunnable {
        private Resource modelResource;
        private Resource traceResource;

        public SaveResourcesWorkspaceRunnable(Resource modelResource, Resource traceResource) {
            this.modelResource = modelResource;
            this.traceResource = traceResource;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Save resources", (int)100);
            subMonitor.split(30);
            try {
                this.traceResource.save(Collections.emptyMap());
                Session session = SessionManager.INSTANCE.getSession(this.modelResource);
                session.save((IProgressMonitor)subMonitor.split(70));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

