/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.ui.CommonHelpers;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorage;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorageImpl;
import org.polarsys.capella.cybersecurity.ui.properties.fields.EnumerationLiterealValueRadioGroup;
import org.polarsys.capella.cybersecurity.ui.properties.sections.Messages;
import org.polarsys.kitalpha.emde.model.EmdePackage;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class SecurityNeedsSection
extends AbstractSection {
    private SecurityNeeds elementExtension;
    private EnumerationLiterealValueRadioGroup confidentiality;
    private EnumerationLiterealValueRadioGroup integrity;
    private EnumerationLiterealValueRadioGroup traceability;
    private EnumerationLiterealValueRadioGroup availability;
    private Group group;

    public boolean select(Object eObject) {
        EObject eObjectToTest = super.selection(eObject);
        if (eObjectToTest == null) {
            return false;
        }
        if (eObjectToTest instanceof SecurityNeeds) {
            return true;
        }
        EObject children = this.getSecurityNeedsObject(eObjectToTest);
        return children != null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        if (newEObject != null && !(newEObject instanceof SecurityNeeds)) {
            newEObject = this.getSecurityNeedsObject(newEObject);
        }
        if (newEObject != null) {
            this.loadData(newEObject);
        }
    }

    private EObject getSecurityNeedsObject(EObject parent) {
        if (parent == null) {
            return null;
        }
        if (!CommonHelpers.isViewpointActive(parent, "org.polarsys.capella.cybersecurity")) {
            return null;
        }
        for (EObject eObject : parent.eContents()) {
            if (!(eObject instanceof SecurityNeeds)) continue;
            return eObject;
        }
        EObject result = null;
        EReference storageRef = this.getStorageRef(parent);
        if (storageRef != null) {
            for (ElementExtensionStorageImpl adapter : parent.eAdapters()) {
                if (!(adapter instanceof ElementExtensionStorage) || !(((ElementExtensionStorage)adapter).getExtension() instanceof SecurityNeeds)) continue;
                result = (EObject)((ElementExtensionStorage)adapter).getExtension();
            }
            if (result == null) {
                ElementExtensionStorageImpl adapter;
                adapter = new ElementExtensionStorageImpl((ExtensibleElement)parent, CybersecurityPackage.Literals.SECURITY_NEEDS);
                result = (EObject)adapter.getExtension();
            }
        }
        return result;
    }

    private EReference getStorageRef(EObject parent) {
        if (CommonHelpers.canBeExtendedBy(parent, CybersecurityPackage.Literals.SECURITY_NEEDS)) {
            return EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS;
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)this.rootParentComposite.getLayout()).numColumns;
        this.group = this.getWidgetFactory().createGroup(this.rootParentComposite, "");
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.group.setLayout((Layout)layout);
        this.group.setLayoutData((Object)gd);
        this.confidentiality = null;
        this.integrity = null;
        this.traceability = null;
        this.availability = null;
    }

    private EnumerationLiterealValueRadioGroup createEnumerationLiteralValueRadioGroup(Group parent, String label, EnumerationPropertyType type) {
        if (parent != null) {
            Composite compo = this.getWidgetFactory().createComposite((Composite)parent);
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            compo.setLayout((Layout)gl);
            compo.setLayoutData((Object)new GridData(4, 4, true, true));
            EnumerationLiterealValueRadioGroup result = new EnumerationLiterealValueRadioGroup(compo, label, type, this.getWidgetFactory(), 4);
            result.setDisplayedInWizard(this.isDisplayedInWizard());
            return result;
        }
        return null;
    }

    private void createSecurityNeedsGroup(Group group, EObject object) {
        EObject element = object;
        if (object instanceof SecurityNeeds) {
            SecurityNeeds need = (SecurityNeeds)object;
            for (Adapter ee : need.eAdapters()) {
                if (!(ee instanceof ElementExtensionStorage)) continue;
                element = ((ElementExtensionStorage)ee).getExtendedElement();
            }
        }
        Session session = SessionManager.INSTANCE.getSession(element);
        Project project = SessionHelper.getCapellaProject((Session)session);
        this.confidentiality = this.createEnumerationLiteralValueRadioGroup(group, Messages.SecurityNeedsSection_1, CybersecurityQueries.getConfidentialityPropertyType((Project)project));
        this.integrity = this.createEnumerationLiteralValueRadioGroup(group, Messages.SecurityNeedsSection_2, CybersecurityQueries.getIntegrityPropertyType((Project)project));
        this.traceability = this.createEnumerationLiteralValueRadioGroup(group, Messages.SecurityNeedsSection_3, CybersecurityQueries.getTraceabilityPropertyType((Project)project));
        this.availability = this.createEnumerationLiteralValueRadioGroup(group, Messages.SecurityNeedsSection_4, CybersecurityQueries.getAvailabilityPropertyType((Project)project));
    }

    public void loadData(EObject object) {
        super.loadData(object);
        if (this.confidentiality == null || this.integrity == null || this.traceability == null || this.availability == null) {
            this.createSecurityNeedsGroup(this.group, object);
        }
        this.confidentiality.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.SECURITY_NEEDS__CONFIDENTIALITY_VALUE);
        this.integrity.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.SECURITY_NEEDS__INTEGRITY_VALUE);
        this.traceability.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.SECURITY_NEEDS__TRACEABILITY_VALUE);
        this.availability.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.SECURITY_NEEDS__AVAILABILITY_VALUE);
        this.elementExtension = (SecurityNeeds)object;
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> abstractSemanticFields = new ArrayList<AbstractSemanticField>();
        abstractSemanticFields.add((AbstractSemanticField)this.confidentiality);
        abstractSemanticFields.add((AbstractSemanticField)this.integrity);
        abstractSemanticFields.add((AbstractSemanticField)this.traceability);
        abstractSemanticFields.add((AbstractSemanticField)this.availability);
        return abstractSemanticFields;
    }

    public void refresh() {
        if (this.elementExtension != null) {
            this.loadData((EObject)this.elementExtension);
        }
    }
}

