/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.odesign;

import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ODesignHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class CyberElementsHaveDeleteDescriptionTest
extends BasicTestCase {
    StringBuilder failedTest = new StringBuilder();

    public void test() throws Exception {
        Viewpoint test = ViewpointRegistry.getInstance().getViewpoint(URI.createURI((String)"viewpoint:/org.polarsys.capella.cybersecurity.sirius.analysis/Cybersecurity"));
        this.checkMappingsHasDeletionDescription(test.eResource());
        if (this.failedTest.length() == 0) {
            CyberElementsHaveDeleteDescriptionTest.assertTrue((boolean)true);
        } else {
            System.err.println(this.failedTest.toString());
            CyberElementsHaveDeleteDescriptionTest.assertTrue((String)this.failedTest.toString(), (boolean)false);
        }
    }

    protected void checkMappingsHasDeletionDescription(Resource resource) {
        List diamap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resource.getAllContents(), 0), false).filter(DiagramElementMapping.class::isInstance).map(x -> (DiagramElementMapping)x).filter(ODesignHelper::isNotDeprecatedMapping).collect(Collectors.toList());
        for (EObject diagramElementMapping : diamap) {
            this.checkHasDeletionDescription((DiagramElementMapping)diagramElementMapping);
        }
    }

    private void checkHasDeletionDescription(DiagramElementMapping diagramElementMapping) {
        EdgeMapping edgeMapping;
        if (diagramElementMapping instanceof AbstractNodeMapping) {
            AbstractNodeMapping nodeMapping = (AbstractNodeMapping)diagramElementMapping;
            if (nodeMapping.getDomainClass() != null && nodeMapping.getDeletionDescription() == null) {
                this.failedTest.append("No Deletion Description for: " + ODesignHelper.computeModelPath((RepresentationElementMapping)diagramElementMapping) + "\n");
            }
        } else if (diagramElementMapping instanceof EdgeMapping && (edgeMapping = (EdgeMapping)diagramElementMapping).isUseDomainElement() && edgeMapping.getDeletionDescription() == null) {
            this.failedTest.append("No Deletion Description for: " + ODesignHelper.computeModelPath((RepresentationElementMapping)diagramElementMapping) + "\n");
        }
    }
}

