/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;

public class PrimaryAssetHelper {
    private static final PrimaryAssetHelper instance = new PrimaryAssetHelper();

    public static PrimaryAssetHelper getInstance() {
        return instance;
    }

    public Object doSwitch(PrimaryAsset object, EStructuralFeature feature) {
        if (feature.equals(CybersecurityPackage.Literals.PRIMARY_ASSET__REALIZED_PRIMARY_ASSETS)) {
            return this.getRealizedPrimaryAssets(object);
        }
        if (feature.equals(CybersecurityPackage.Literals.PRIMARY_ASSET__REALIZING_PRIMARY_ASSETS)) {
            return this.getRealizingPrimaryAssets(object);
        }
        return NamedElementHelper.getInstance().doSwitch((NamedElement)object, feature);
    }

    protected List<PrimaryAsset> getRealizedPrimaryAssets(PrimaryAsset element) {
        ArrayList<PrimaryAsset> ret = new ArrayList<PrimaryAsset>();
        for (AbstractTrace obj : element.getOutgoingTraces()) {
            TransfoLink link;
            if (!(obj instanceof TransfoLink) || !((link = (TransfoLink)obj).getTarget() instanceof PrimaryAsset)) continue;
            ret.add((PrimaryAsset)link.getTarget());
        }
        return ret;
    }

    protected List<PrimaryAsset> getRealizingPrimaryAssets(PrimaryAsset element) {
        ArrayList<PrimaryAsset> ret = new ArrayList<PrimaryAsset>();
        for (AbstractTrace obj : element.getIncomingTraces()) {
            TransfoLink link;
            if (!(obj instanceof TransfoLink) || !((link = (TransfoLink)obj).getSource() instanceof PrimaryAsset)) continue;
            ret.add((PrimaryAsset)link.getSource());
        }
        return ret;
    }
}

