/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticKindGroup;

public class IntegerValueRadioGroup
extends AbstractSemanticKindGroup {
    private List<Button> buttons = new ArrayList<Button>();

    public IntegerValueRadioGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, int min, int max) {
        super(parent, widgetFactory, label, max - min + 1);
        int i = min;
        while (i <= max) {
            Button button = this.createButton((Composite)this._group, String.valueOf(i), i, true, 16);
            this.buttons.add(button);
            ++i;
        }
    }

    public List<Button> getSemanticFields() {
        return this.buttons;
    }

    public Button getDefaultSemanticField() {
        return this.buttons.get(0);
    }

    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    public void loadData(EObject capellaElement, EStructuralFeature feature) {
        super.loadData(capellaElement, feature);
        Object value = this.semanticElement.eGet(this.semanticFeature);
        if (value == null) {
            Button defaultBtn = this.getDefaultSemanticField();
            if (defaultBtn != null) {
                defaultBtn.setSelection(true);
            }
        } else {
            for (Button button : this.getSemanticFields()) {
                if (button == null) continue;
                button.setSelection(value == button.getData());
            }
        }
    }
}

