/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.navigator;

import java.util.Collection;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class SubProjectViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = (IResource)Platform.getAdapterManager().getAdapter(element, IResource.class);
        return resource == null || !this.isSubProject(resource);
    }

    private boolean isSubProject(IResource resource) {
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            return this.isSubProjectFolder(folder);
        }
        return false;
    }

    private boolean isSubProjectFolder(IFolder folder) {
        try {
            PersistentModel model = CorePlugin.modelPersistence().loadModel(folder.getProject());
            if (model.isPresent()) {
                Collection paths = model.getSubprojectPaths();
                return paths != null && paths.contains(folder.getFullPath());
            }
            return false;
        }
        catch (Exception e) {
            CorePlugin.logger().debug(String.format("Could not check whether folder %s is a sub project.", folder.getFullPath()), (Throwable)e);
            return false;
        }
    }
}

