/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.gradle.LoadEclipseGradleBuildsJob;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.buildship.ui.view.task.TaskViewContent;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;

public final class TaskViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final TaskView taskView;
    private final ModelRepositoryProvider modelRepositoryProvider;
    private final ProcessStreamsProvider processStreamsProvider;
    private final WorkspaceOperations workspaceOperations;

    public TaskViewContentProvider(TaskView taskView, ModelRepositoryProvider modelRepositoryProvider, ProcessStreamsProvider processStreamsProvider, WorkspaceOperations workspaceOperations) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        this.modelRepositoryProvider = (ModelRepositoryProvider)Preconditions.checkNotNull((Object)modelRepositoryProvider);
        this.processStreamsProvider = (ProcessStreamsProvider)Preconditions.checkNotNull((Object)processStreamsProvider);
        this.workspaceOperations = (WorkspaceOperations)Preconditions.checkNotNull((Object)workspaceOperations);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        TaskViewContent content = (TaskViewContent)TaskViewContent.class.cast(newInput);
        LoadEclipseGradleBuildsJob loadEclipseGradleBuildsJob = new LoadEclipseGradleBuildsJob(this.modelRepositoryProvider, this.processStreamsProvider, content.getModelFetchStrategy(), content.getRootProjectConfigurations(), (FutureCallback)new LoadEclipseGradleBuildPostProcess(this.taskView));
        loadEclipseGradleBuildsJob.schedule();
    }

    public Object[] getElements(Object input) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (input instanceof TaskViewContent) {
            TaskViewContent content = (TaskViewContent)input;
            for (ProjectConfiguration projectConfiguration : content.getRootProjectConfigurations()) {
                result.addAll(this.createTopLevelProjectNodes(projectConfiguration));
            }
        }
        return result.build().toArray();
    }

    private List<ProjectNode> createTopLevelProjectNodes(ProjectConfiguration projectConfiguration) {
        OmniEclipseGradleBuild gradleBuild = this.fetchCachedEclipseGradleBuild(projectConfiguration.getRequestAttributes());
        if (gradleBuild == null) {
            return ImmutableList.of();
        }
        ArrayList allProjectNodes = Lists.newArrayList();
        this.collectProjectNodesRecursively(gradleBuild.getRootEclipseProject(), gradleBuild.getRootProject(), null, allProjectNodes);
        return allProjectNodes;
    }

    private OmniEclipseGradleBuild fetchCachedEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes) {
        ImmutableList noProgressListeners = ImmutableList.of();
        ImmutableList noTypedProgressListeners = ImmutableList.of();
        CancellationToken cancellationToken = GradleConnector.newCancellationTokenSource().token();
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, null, null, null, (List)noProgressListeners, (List)noTypedProgressListeners, cancellationToken);
        ModelRepository repository = this.modelRepositoryProvider.getModelRepository(fixedRequestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FROM_CACHE_ONLY);
    }

    private void collectProjectNodesRecursively(OmniEclipseProject eclipseProject, OmniGradleProject gradleRootProject, ProjectNode parentProjectNode, List<ProjectNode> allProjectNodes) {
        Path gradleProjectPath = eclipseProject.getPath();
        OmniGradleProject gradleProject = (OmniGradleProject)gradleRootProject.tryFind(Specs.gradleProjectMatchesProjectPath((Path)gradleProjectPath)).get();
        Optional workspaceProject = this.workspaceOperations.findProjectByLocation(eclipseProject.getProjectDirectory());
        ProjectNode projectNode = new ProjectNode(parentProjectNode, eclipseProject, gradleProject, (Optional<IProject>)workspaceProject);
        allProjectNodes.add(projectNode);
        for (OmniEclipseProject childProject : eclipseProject.getChildren()) {
            this.collectProjectNodesRecursively(childProject, gradleRootProject, projectNode, allProjectNodes);
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof ProjectNode;
    }

    public Object[] getChildren(Object parent) {
        return parent instanceof ProjectNode ? this.childrenOf((ProjectNode)parent) : NO_CHILDREN;
    }

    private Object[] childrenOf(ProjectNode projectNode) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (OmniProjectTask projectTask : projectNode.getGradleProject().getProjectTasks()) {
            result.add((Object)new ProjectTaskNode(projectNode, projectTask));
        }
        for (OmniTaskSelector taskSelector : projectNode.getGradleProject().getTaskSelectors()) {
            result.add((Object)new TaskSelectorNode(projectNode, taskSelector));
        }
        return FluentIterable.from((Iterable)result.build()).toArray(TaskNode.class);
    }

    public Object getParent(Object element) {
        if (element instanceof ProjectNode) {
            return ((ProjectNode)element).getParentProjectNode();
        }
        if (element instanceof TaskNode) {
            return ((TaskNode)element).getParentProjectNode();
        }
        return null;
    }

    public void dispose() {
    }

    private static final class LoadEclipseGradleBuildPostProcess
    implements FutureCallback<OmniEclipseGradleBuild> {
        private final TaskView taskView;

        private LoadEclipseGradleBuildPostProcess(TaskView taskView) {
            this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        }

        public void onSuccess(OmniEclipseGradleBuild omniEclipseGradleBuild) {
            this.refreshTaskView();
        }

        public void onFailure(Throwable throwable) {
            this.refreshTaskView();
        }

        private void refreshTaskView() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LoadEclipseGradleBuildPostProcess.this.taskView.refresh();
                }
            });
        }
    }
}

