/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.util;

import com.google.common.base.Optional;

public final class Maybe<T> {
    private static final Maybe<Object> ABSENT = new Maybe(Optional.absent());
    private static final Object NULL_REFERENCE = new Object();
    private final Optional<T> optional;

    private Maybe(Optional<T> optional) {
        this.optional = optional;
    }

    public boolean isPresent() {
        return this.optional.isPresent();
    }

    public T get() {
        if (this.optional.isPresent()) {
            Object value = this.optional.get();
            if (value == NULL_REFERENCE) {
                return null;
            }
            return (T)value;
        }
        throw new IllegalStateException("Maybe.get() cannot be called on an absent value.");
    }

    public T or(T defaultValue) {
        return this.optional.isPresent() ? this.get() : defaultValue;
    }

    public static <T> Maybe<T> of(T reference) {
        return new Maybe<T>(Optional.of(reference != null ? reference : Maybe.typeSafeNullValue()));
    }

    private static <T> T typeSafeNullValue() {
        return (T)NULL_REFERENCE;
    }

    public static <T> Maybe<T> absent() {
        return Maybe.typeSafeAbsent();
    }

    private static <T> Maybe<T> typeSafeAbsent() {
        return ABSENT;
    }
}

