/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.RunGradleTestLaunchRequestJob;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.gradle.GradleUtils;
import org.eclipse.buildship.ui.view.execution.ExecutionPage;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class RerunFailedTestsAction
extends Action {
    private final ExecutionPage page;

    public RerunFailedTestsAction(ExecutionPage executionPage) {
        this.page = (ExecutionPage)Preconditions.checkNotNull((Object)executionPage);
        this.setToolTipText(UiMessages.Action_RerunFailedTests_Tooltip);
        this.setImageDescriptor(PluginImages.RERUN_FAILED_TESTS.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.RERUN_FAILED_TESTS.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Job job = this.page.getProcessDescription().getJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RerunFailedTestsAction.this.update();
            }
        });
        this.update();
    }

    private void update() {
        this.setEnabled(this.page.getProcessDescription().getJob().getState() == 0 && !this.collectFailedTests().isEmpty());
    }

    public void run() {
        ImmutableList<TestOperationDescriptor> failedTests = this.collectFailedTests();
        List<TestOperationDescriptor> filteredFailedTests = GradleUtils.filterChildren(failedTests);
        GradleRunConfigurationAttributes configurationAttributes = this.page.getProcessDescription().getConfigurationAttributes();
        RunGradleTestLaunchRequestJob job = new RunGradleTestLaunchRequestJob(filteredFailedTests, configurationAttributes);
        job.schedule();
    }

    private ImmutableList<TestOperationDescriptor> collectFailedTests() {
        return this.page.filterTreeNodes(new Predicate<OperationItem>(){

            public boolean apply(OperationItem operationItem) {
                return RerunFailedTestsAction.this.isFailedJvmTest(operationItem);
            }
        }).transform((Function)new Function<OperationItem, TestOperationDescriptor>(){

            public TestOperationDescriptor apply(OperationItem operationItem) {
                return (JvmTestOperationDescriptor)operationItem.getFinishEvent().getDescriptor();
            }
        }).toList();
    }

    private boolean isFailedJvmTest(OperationItem operationItem) {
        JvmTestOperationDescriptor descriptor;
        TestFinishEvent testFinishEvent;
        return operationItem.getFinishEvent() instanceof TestFinishEvent && (testFinishEvent = (TestFinishEvent)operationItem.getFinishEvent()).getResult() instanceof TestFailureResult && testFinishEvent.getDescriptor() instanceof JvmTestOperationDescriptor && ((descriptor = (JvmTestOperationDescriptor)testFinishEvent.getDescriptor()).getJvmTestKind() == JvmTestKind.ATOMIC || descriptor.getJvmTestKind() == JvmTestKind.UNKNOWN);
    }
}

