/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeSpec<T>
implements Spec<T> {
    private final Spec<? super T>[] specs;

    protected CompositeSpec(Spec<? super T> ... specs) {
        this(Arrays.asList(specs));
    }

    protected CompositeSpec(Iterable<? extends Spec<? super T>> specs) {
        ArrayList<Spec<T>> copy = new ArrayList<Spec<T>>();
        for (Spec<T> spec : specs) {
            copy.add(spec);
        }
        this.specs = copy.toArray(new Spec[copy.size()]);
    }

    Spec<? super T>[] getSpecsArray() {
        return this.specs;
    }

    public List<Spec<? super T>> getSpecs() {
        return Collections.unmodifiableList(Arrays.asList(this.specs));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeSpec)) {
            return false;
        }
        CompositeSpec that = (CompositeSpec)o;
        return Arrays.equals(this.specs, that.specs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.specs);
    }
}

