/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniAccessRule;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.repository.internal.AbstractOmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.repository.internal.ForwardCompatibilityConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.compatibility.ForwardCompatibilityEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import org.gradle.tooling.model.eclipse.EclipseSourceDirectory;

public final class DefaultOmniEclipseSourceDirectory
extends AbstractOmniClasspathEntry
implements OmniEclipseSourceDirectory {
    private final File directory;
    private final String path;
    private final Optional<List<String>> excludes;
    private final Optional<List<String>> includes;
    private final Maybe<String> output;

    private DefaultOmniEclipseSourceDirectory(File directory, String path, Optional<List<String>> excludes, Optional<List<String>> includes, Maybe<String> output, Optional<List<OmniClasspathAttribute>> attributes, Optional<List<OmniAccessRule>> accessRules) {
        super(attributes, accessRules);
        this.directory = directory;
        this.path = path;
        this.excludes = excludes;
        this.includes = includes;
        this.output = output;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Optional<List<String>> getExcludes() {
        return this.excludes;
    }

    @Override
    public Optional<List<String>> getIncludes() {
        return this.includes;
    }

    @Override
    public Maybe<String> getOutput() {
        return this.output;
    }

    public static DefaultOmniEclipseSourceDirectory from(EclipseSourceDirectory sourceDirectory) {
        ForwardCompatibilityEclipseSourceDirectory compatibilityDirectory = ForwardCompatibilityConverter.convert(sourceDirectory, ForwardCompatibilityEclipseSourceDirectory.class);
        return new DefaultOmniEclipseSourceDirectory(sourceDirectory.getDirectory(), sourceDirectory.getPath(), DefaultOmniEclipseSourceDirectory.getExcludes(compatibilityDirectory), DefaultOmniEclipseSourceDirectory.getIncludes(compatibilityDirectory), DefaultOmniEclipseSourceDirectory.getOutput(compatibilityDirectory), DefaultOmniEclipseSourceDirectory.getClasspathAttributes(compatibilityDirectory), DefaultOmniEclipseSourceDirectory.getAccessRules(compatibilityDirectory));
    }

    private static Optional<List<String>> getExcludes(ForwardCompatibilityEclipseSourceDirectory sourceDirectory) {
        try {
            return Optional.of(sourceDirectory.getExcludes());
        }
        catch (Exception ignore) {
            return Optional.absent();
        }
    }

    private static Optional<List<String>> getIncludes(ForwardCompatibilityEclipseSourceDirectory sourceDirectory) {
        try {
            return Optional.of(sourceDirectory.getIncludes());
        }
        catch (Exception ignore) {
            return Optional.absent();
        }
    }

    private static Maybe<String> getOutput(ForwardCompatibilityEclipseSourceDirectory sourceDirectory) {
        try {
            return Maybe.of(sourceDirectory.getOutput());
        }
        catch (Exception ignore) {
            return Maybe.absent();
        }
    }
}

