/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.net.URI;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;

@Contextual
public class ResourceException
extends GradleException {
    private final URI location;

    public ResourceException(URI location, String message) {
        super(message);
        this.location = location;
    }

    public ResourceException(URI location, String message, Throwable cause) {
        super(message, cause);
        this.location = location;
    }

    public ResourceException(String message, Throwable cause) {
        super(message, cause);
        this.location = null;
    }

    public static ResourceException getFailed(URI location, Throwable failure) {
        return ResourceException.failure(location, String.format("Could not get resource '%s'.", location), failure);
    }

    public static ResourceException putFailed(URI location, Throwable failure) {
        return ResourceException.failure(location, String.format("Could not write to resource '%s'.", location), failure);
    }

    public static ResourceException failure(URI location, String message, Throwable failure) {
        ResourceException resourceException;
        if (failure instanceof ResourceException && location.equals((resourceException = (ResourceException)failure).getLocation())) {
            return resourceException;
        }
        return new ResourceException(location, message, failure);
    }

    public URI getLocation() {
        return this.location;
    }
}

