/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CharSequenceNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final NotationConverter<String, ? extends T> delegate;

    public CharSequenceNotationConverter(NotationConverter<String, ? extends T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (notation instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)notation;
            this.delegate.convert(charSequence.toString(), result);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
    }
}

