/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class DiagonalLineImage {
    private int diagonalNumber = -1;
    private String diagonalStyle = null;
    private DimensionType diagonalWidth = null;
    private int antidiagonalNumber = -1;
    private String diagonalColor = null;
    private DimensionType antidiagonalWidth = null;
    private Color color = null;
    DimensionType imageWidth = null;
    DimensionType imageHeight = null;
    protected int imageDpi = -1;
    Stroke originStroke = null;
    private static int DEFAULT_IMAGE_PX_WIDTH = 200;
    private static int DEFAULT_IMAGE_PX_HEIGHT = 200;
    private static int DEFAULT_IMAGE_DPI = 96;

    public void setDiagonalLine(int diagonalNumber, String diagonalStyle, DimensionType diagonalWidth, String diagonalColor) {
        this.diagonalNumber = diagonalNumber;
        this.diagonalStyle = diagonalStyle;
        this.diagonalWidth = diagonalWidth;
        this.diagonalColor = diagonalColor;
    }

    public void setAntidiagonalLine(int antidiagonalNumber, String antidiagonalStyle, DimensionType antidiagonalWidth, String antidiagonalColor) {
        this.antidiagonalNumber = antidiagonalNumber;
        this.antidiagonalWidth = antidiagonalWidth;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setImageDpi(int dpi) {
        this.imageDpi = dpi;
    }

    public void setImageSize(DimensionType imageWidth, DimensionType imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public byte[] drawImage() throws IOException {
        int antidiagonalPXWidth;
        int diagonalPXWidth;
        if (this.diagonalNumber <= 0 && this.antidiagonalNumber <= 0) {
            return null;
        }
        if (this.imageDpi < 0) {
            this.imageDpi = DEFAULT_IMAGE_DPI;
        }
        int imagePXWidth = HTMLEmitterUtil.getDimensionPixelValue(this.imageWidth, this.imageDpi);
        int imagePXHeight = HTMLEmitterUtil.getDimensionPixelValue(this.imageHeight, this.imageDpi);
        if (imagePXWidth <= 0) {
            imagePXWidth = DEFAULT_IMAGE_PX_WIDTH;
        }
        if (imagePXHeight <= 0) {
            imagePXHeight = DEFAULT_IMAGE_PX_HEIGHT;
        }
        if ((diagonalPXWidth = HTMLEmitterUtil.getDimensionPixelValue(this.diagonalWidth, this.imageDpi)) <= 0) {
            diagonalPXWidth = 1;
        }
        if ((antidiagonalPXWidth = HTMLEmitterUtil.getDimensionPixelValue(this.antidiagonalWidth, this.imageDpi)) <= 0) {
            antidiagonalPXWidth = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(imagePXWidth, imagePXHeight, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        this.originStroke = g2d.getStroke();
        try {
            if (this.diagonalStyle != null && !"none".equalsIgnoreCase(this.diagonalStyle)) {
                float[] dash;
                Color lineColor = PropertyUtil.getColor((String)this.diagonalColor);
                if (lineColor == null) {
                    lineColor = this.color;
                }
                if (lineColor != null) {
                    g2d.setColor(lineColor);
                }
                if ("dotted".equalsIgnoreCase(this.diagonalStyle)) {
                    dash = new float[]{1.0f, diagonalPXWidth * 2 - 1 + diagonalPXWidth % 2};
                    BasicStroke stroke = new BasicStroke(diagonalPXWidth, 1, 1, 10.0f, dash, diagonalPXWidth * 2 - diagonalPXWidth / 2);
                    g2d.setStroke(stroke);
                    if (this.diagonalNumber == 1) {
                        g2d.drawLine(0, diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                    } else if (this.diagonalNumber == 2) {
                        g2d.drawLine(imagePXWidth / 3 - 1, diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                        g2d.drawLine(0, imagePXHeight / 3 - 1 + diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                    } else if (this.diagonalNumber >= 3) {
                        g2d.drawLine(imagePXWidth / 2 - 1, diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                        g2d.drawLine(0, diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                        g2d.drawLine(0, imagePXHeight / 2 - 1 + diagonalPXWidth / 2, imagePXWidth - 1, imagePXHeight - 1 + diagonalPXWidth / 2);
                    }
                } else {
                    if ("dashed".equalsIgnoreCase(this.diagonalStyle)) {
                        dash = new float[]{3 * diagonalPXWidth};
                        BasicStroke stroke = new BasicStroke(diagonalPXWidth, 0, 0, 10.0f, dash, 0.0f);
                        g2d.setStroke(stroke);
                    } else if (diagonalPXWidth > 1) {
                        g2d.setStroke(new BasicStroke(diagonalPXWidth));
                    }
                    if (this.diagonalNumber == 1) {
                        g2d.drawLine(0, 0, imagePXWidth - 1, imagePXHeight - 1);
                    } else if (this.diagonalNumber == 2) {
                        g2d.drawLine(imagePXWidth / 3 - 1, 0, imagePXWidth - 1, imagePXHeight - 1);
                        g2d.drawLine(0, imagePXHeight / 3 - 1, imagePXWidth - 1, imagePXHeight - 1);
                    } else if (this.diagonalNumber >= 3) {
                        g2d.drawLine(imagePXWidth / 2 - 1, 0, imagePXWidth - 1, imagePXHeight - 1);
                        g2d.drawLine(0, 0, imagePXWidth - 1, imagePXHeight - 1);
                        g2d.drawLine(0, imagePXHeight / 2 - 1, imagePXWidth - 1, imagePXHeight - 1);
                    }
                }
            }
        }
        finally {
            g2d.dispose();
        }
        ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", imageStream);
        imageStream.flush();
        byte[] resultImageByteArray = imageStream.toByteArray();
        imageStream.close();
        return resultImageByteArray;
    }
}

