/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSOutputParams
extends ScriptableObject {
    private DataSetRuntime dataSet;
    private static final long serialVersionUID = 2535883419826794186L;

    public JSOutputParams(DataSetRuntime dataSet) {
        this.dataSet = dataSet;
    }

    public String getClassName() {
        return "OutputParams";
    }

    public Object get(int index, Scriptable scope) {
        return NOT_FOUND;
    }

    public Object get(String name, Scriptable scope) {
        try {
            Object paramValue = this.dataSet.getOutputParameterValue(name);
            return JavascriptEvalUtil.convertToJavascriptValue((Object)paramValue, (Scriptable)this.dataSet.getSharedScope());
        }
        catch (BirtException e) {
            throw Context.reportRuntimeError((String)e.getLocalizedMessage());
        }
    }

    public void put(int index, Scriptable scope, Object value) {
        throw new IllegalArgumentException("Put value on output parameter object is not supported.");
    }

    public void put(String name, Scriptable scope, Object value) {
        try {
            this.dataSet.setOutputParameterValue(name, value);
        }
        catch (BirtException birtException) {
            // empty catch block
        }
    }

    public boolean has(int index, Scriptable start) {
        return super.has(index, start);
    }

    public boolean has(String name, Scriptable start) {
        if (this.dataSet.hasOutputParameter(name)) {
            return true;
        }
        return super.has(name, start);
    }
}

