/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DrilledInfo;

public class AggregationDefinition {
    private DimLevel[] levels;
    private int[] sortTypes;
    private AggregationFunctionDefinition[] aggregationFunctions;
    private AggregationFunctionDefinition[] aggregationTimeFunctions;
    private DrilledInfo drilledAggregation;

    public AggregationDefinition(DimLevel[] levels, int[] sortTypes, AggregationFunctionDefinition[] aggregationFunctions) {
        this.levels = levels;
        int timeFunctionCount = 0;
        if (aggregationFunctions != null) {
            int i = 0;
            while (i < aggregationFunctions.length) {
                if (aggregationFunctions[i].getTimeFunction() != null) {
                    ++timeFunctionCount;
                }
                ++i;
            }
            this.aggregationFunctions = new AggregationFunctionDefinition[aggregationFunctions.length];
            if (timeFunctionCount > 0) {
                this.aggregationTimeFunctions = new AggregationFunctionDefinition[timeFunctionCount];
            }
            int ptr = 0;
            int tPtr = 0;
            int i2 = 0;
            while (i2 < aggregationFunctions.length) {
                if (aggregationFunctions[i2].getTimeFunction() == null) {
                    this.aggregationFunctions[ptr++] = aggregationFunctions[i2];
                } else {
                    this.aggregationTimeFunctions[tPtr++] = aggregationFunctions[i2];
                }
                ++i2;
            }
            if (timeFunctionCount > 0) {
                i2 = 0;
                while (i2 < this.aggregationTimeFunctions.length) {
                    this.aggregationFunctions[ptr++] = this.aggregationTimeFunctions[i2];
                    ++i2;
                }
            }
        }
        this.sortTypes = sortTypes;
        if (this.levels != null && this.levels.length == 0) {
            this.levels = null;
            this.sortTypes = null;
        }
    }

    public AggregationFunctionDefinition[] getAggregationTimeFunctions() {
        return this.aggregationTimeFunctions;
    }

    public AggregationFunctionDefinition[] getAggregationFunctions() {
        return this.aggregationFunctions;
    }

    public void setAggregationFunctions(AggregationFunctionDefinition[] aggregationFunctions) {
        int timeFunctionCount = 0;
        int i = 0;
        while (i < aggregationFunctions.length) {
            if (aggregationFunctions[i].getTimeFunction() != null) {
                ++timeFunctionCount;
            }
            ++i;
        }
        this.aggregationFunctions = new AggregationFunctionDefinition[aggregationFunctions.length - timeFunctionCount];
        this.aggregationTimeFunctions = new AggregationFunctionDefinition[aggregationFunctions.length - timeFunctionCount];
        int ptr = 0;
        int tPtr = 0;
        int i2 = 0;
        while (i2 < aggregationFunctions.length) {
            if (aggregationFunctions[i2].getTimeFunction() == null) {
                this.aggregationFunctions[ptr++] = aggregationFunctions[i2];
            } else {
                this.aggregationTimeFunctions[tPtr++] = aggregationFunctions[i2];
            }
            ++i2;
        }
    }

    public DimLevel[] getLevels() {
        return this.levels;
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }

    public void setDrilledInfo(DrilledInfo aggregation) {
        this.drilledAggregation = aggregation;
    }

    public DrilledInfo getDrilledInfo() {
        return this.drilledAggregation;
    }
}

