/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api.cube;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;

public class TimeDimensionUtil {
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String WEEK_OF_YEAR = "week_of_year";
    public static final String WEEK_OF_MONTH = "week_of_month";
    public static final String DAY_OF_MONTH = "day";
    public static final String DAY_OF_YEAR = "day_of_year";
    public static final String DAY_OF_WEEK = "day_of_week";
    public static final String HOUR = "hour";
    public static final String HOUR_OF_DAY = "hour_of_day";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    public static final String MILLISECOND = "millisecond";
    private static TimeZone timeZone = null;
    private static IScriptFunctionContext scriptContext = null;

    public static void setContext(IScriptFunctionContext context) {
        scriptContext = context;
        if (scriptContext != null) {
            timeZone = (TimeZone)scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.timeZone");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
    }

    public static int getFieldIndex(String fieldName) {
        if (fieldName.equals(YEAR)) {
            return 1;
        }
        if (fieldName.equals(MONTH)) {
            return 2;
        }
        if (fieldName.equals(WEEK_OF_YEAR)) {
            return 3;
        }
        if (fieldName.equals(WEEK_OF_MONTH)) {
            return 4;
        }
        if (fieldName.equals(DAY_OF_MONTH)) {
            return 5;
        }
        if (fieldName.equals(DAY_OF_YEAR)) {
            return 6;
        }
        if (fieldName.equals(DAY_OF_WEEK)) {
            return 7;
        }
        if (fieldName.equals(HOUR)) {
            return 10;
        }
        if (fieldName.equals(HOUR_OF_DAY)) {
            return 11;
        }
        if (fieldName.equals(MINUTE)) {
            return 12;
        }
        if (fieldName.equals(SECOND)) {
            return 13;
        }
        if (fieldName.equals(MILLISECOND)) {
            return 14;
        }
        return -1;
    }

    public static String getFieldName(int fieldIndex) {
        switch (fieldIndex) {
            case 1: {
                return YEAR;
            }
            case 2: {
                return MONTH;
            }
            case 3: {
                return WEEK_OF_YEAR;
            }
            case 4: {
                return WEEK_OF_MONTH;
            }
            case 5: {
                return DAY_OF_MONTH;
            }
            case 6: {
                return DAY_OF_YEAR;
            }
            case 7: {
                return DAY_OF_WEEK;
            }
            case 10: {
                return HOUR;
            }
            case 11: {
                return HOUR_OF_DAY;
            }
            case 12: {
                return MINUTE;
            }
            case 13: {
                return SECOND;
            }
            case 14: {
                return MILLISECOND;
            }
        }
        return null;
    }

    public static Integer getFieldVaule(Date d, int fieldIndex) {
        Calendar c = TimeDimensionUtil.getCalendar(d);
        return c.get(fieldIndex);
    }

    public static Integer getFieldVaule(Date d, String fieldName) {
        return TimeDimensionUtil.getFieldVaule(d, TimeDimensionUtil.getFieldIndex(fieldName));
    }

    private static Calendar getCalendar(Date d) {
        Calendar c = null;
        c = timeZone == null ? Calendar.getInstance() : Calendar.getInstance((TimeZone)timeZone);
        c.setTime(d);
        return c;
    }
}

