/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IFilterByRow;
import org.eclipse.birt.data.engine.script.FilterPassController;

class FilterCalculator {
    protected ResultSetPopulator populator;
    protected IFilterByRow filterByRow;
    protected DataEngineSession session;

    protected FilterCalculator(ResultSetPopulator populator, IFilterByRow filterByRow) {
        this.populator = populator;
        this.filterByRow = filterByRow;
        this.session = populator.getSession();
    }

    static void applyFilters(ResultSetPopulator populator, IFilterByRow filterByRow) throws DataException {
        new FilterCalculator(populator, filterByRow).applyFilters();
    }

    protected void applyFilters() throws DataException {
        FilterPassController filterPass = new FilterPassController();
        Iterator<IFilterDefinition> filterIt = this.filterByRow.getFilterList().iterator();
        while (filterIt.hasNext()) {
            FilterUtil.prepareFilterExpression(this.session.getTempDir(), filterIt.next().getExpression(), filterPass, this.populator.getEventHandler().getExecutorHelper());
        }
        this.doFiltering(filterPass);
    }

    protected void doFiltering(FilterPassController filterPass) throws DataException {
        boolean needMultiPass = FilterUtil.hasMutipassFilters(this.filterByRow.getFilterList());
        if (needMultiPass) {
            this.makeMultiPassToFilter(filterPass);
        } else {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        }
    }

    protected void makeMultiPassToFilter(FilterPassController filterPass) throws DataException {
        int max = this.populator.getQuery().getMaxRows();
        this.populator.getQuery().setMaxRows(0);
        this.makeFirstPassToMultiPassFilter(filterPass);
        ResultSetCache sCache = this.populator.getCache();
        this.populator.setClearCacheResultSet(false);
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setLeaveGroupIndex(0);
        sCache.reset();
        sCache.next();
        this.makePreparationPassToMultiPassFilter(filterPass);
        this.populator.setCache(sCache);
        sCache.reset();
        sCache.next();
        this.populator.setClearCacheResultSet(true);
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setLeaveGroupIndex(0);
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().setResultSetCache(sCache);
        this.populator.getQuery().setMaxRows(max);
        this.makeSecondPassToMultiPassFilter(filterPass);
        for (IFilterDefinition fd : this.filterByRow.getFilterList()) {
            if (!FilterUtil.isFilterNeedMultiPass(fd)) continue;
            fd.getExpression().setHandle(null);
        }
        filterPass.setSecondPassRowCount(0);
    }

    protected void makeFirstPassToMultiPassFilter(FilterPassController filterPass) throws DataException {
        filterPass.setForceReset(true);
        filterPass.setPassLevel(1);
        filterPass.setRowCount(this.populator.getCache().getCount());
        ArrayList<IFilterDefinition> temp = new ArrayList<IFilterDefinition>(this.filterByRow.getFilterList());
        this.filterByRow.getFilterList().clear();
        int i = 0;
        while (i < temp.size()) {
            if (!FilterUtil.isFilterNeedMultiPass((IFilterDefinition)temp.get(i))) {
                this.filterByRow.getFilterList().add((IFilterDefinition)temp.get(i));
            }
            ++i;
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        this.filterByRow.getFilterList().clear();
        this.filterByRow.getFilterList().addAll(temp);
    }

    protected void makePreparationPassToMultiPassFilter(FilterPassController filterPass) throws DataException {
        filterPass.setForceReset(true);
        filterPass.setPassLevel(1);
        filterPass.setRowCount(this.populator.getCache().getCount());
        ArrayList<IFilterDefinition> temp = new ArrayList<IFilterDefinition>(this.filterByRow.getFilterList());
        this.filterByRow.getFilterList().clear();
        int i = 0;
        while (i < temp.size()) {
            if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)temp.get(i))) {
                this.filterByRow.getFilterList().add((IFilterDefinition)temp.get(i));
            }
            ++i;
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        this.filterByRow.getFilterList().clear();
        this.filterByRow.getFilterList().addAll(temp);
    }

    protected void makeSecondPassToMultiPassFilter(FilterPassController filterPass) throws DataException {
        filterPass.setPassLevel(2);
        ArrayList<IFilterDefinition> temp = new ArrayList<IFilterDefinition>(this.filterByRow.getFilterList());
        this.filterByRow.getFilterList().clear();
        int i = 0;
        while (i < temp.size()) {
            if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)temp.get(i))) {
                this.filterByRow.getFilterList().add((IFilterDefinition)temp.get(i));
            }
            ++i;
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        filterPass.setPassLevel(0);
        filterPass.setRowCount(-1);
        this.filterByRow.getFilterList().clear();
        this.filterByRow.getFilterList().addAll(temp);
    }
}

