/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommand;

public class GroupMultiRowReorderCommand
extends MultiRowReorderCommand {
    private GroupModel.Group groupToTop;
    private GroupModel.Group groupToBottom;

    public GroupMultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition) {
        this(layer, fromRowPositions, toRowPosition < layer.getRowCount() ? toRowPosition : toRowPosition - 1, toRowPosition < layer.getRowCount());
    }

    public GroupMultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        super(layer, fromRowPositions.stream().mapToInt(Integer::intValue).toArray(), toRowPosition, reorderToTopEdge);
    }

    public GroupMultiRowReorderCommand(ILayer layer, int[] fromRowPositions, int toRowPosition) {
        this(layer, fromRowPositions, toRowPosition < layer.getRowCount() ? toRowPosition : toRowPosition - 1, toRowPosition < layer.getRowCount());
    }

    public GroupMultiRowReorderCommand(ILayer layer, int[] fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        super(layer, fromRowPositions, toRowPosition, reorderToTopEdge);
    }

    protected GroupMultiRowReorderCommand(GroupMultiRowReorderCommand command) {
        super(command);
        this.groupToTop = command.groupToTop;
        this.groupToBottom = command.groupToBottom;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            int groupEndPosition;
            if (this.groupToBottom != null) {
                int groupStartPosition;
                if (this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getRowPositionByIndex(this.groupToBottom.getStartIndex())) >= 0 && groupStartPosition < this.getToRowPosition()) {
                    this.toRowPositionCoordinate.rowPosition = groupStartPosition;
                }
            } else if (this.groupToTop != null && !this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.groupToTop.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToRowPosition()) {
                this.toRowPositionCoordinate.rowPosition = groupEndPosition;
            }
            return true;
        }
        return false;
    }

    public void setGroupToTop(GroupModel.Group groupToTop) {
        this.groupToTop = groupToTop;
    }

    public void setGroupToBottom(GroupModel.Group groupToBottom) {
        this.groupToBottom = groupToBottom;
    }

    @Override
    public GroupMultiRowReorderCommand cloneCommand() {
        return new GroupMultiRowReorderCommand(this);
    }
}

