/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditor;
import org.eclipse.fordiac.ide.application.editors.ApplicationEditorInput;
import org.eclipse.fordiac.ide.application.editors.SubAppNetworkEditor;
import org.eclipse.fordiac.ide.application.editors.SubApplicationEditorInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeAndSubAppInstanceViewerInput;
import org.eclipse.fordiac.ide.fbtypeeditor.network.viewer.CompositeInstanceViewer;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.DiagramOutlinePage;
import org.eclipse.fordiac.ide.gef.annotation.FordiacMarkerGraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.validation.ValidationJob;
import org.eclipse.fordiac.ide.model.commands.QualNameChangeListenerManager;
import org.eclipse.fordiac.ide.model.edit.ITypeEntryEditor;
import org.eclipse.fordiac.ide.model.edit.TypeEntryAdapter;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListenerManager;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.listeners.EditorTabCommandStackListener;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceDiagramEditor;
import org.eclipse.fordiac.ide.resourceediting.editors.ResourceEditorInput;
import org.eclipse.fordiac.ide.subapptypeeditor.viewer.SubappInstanceViewer;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditor;
import org.eclipse.fordiac.ide.systemconfiguration.editor.SystemConfigurationEditorInput;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.editors.SystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.AutomationSystemProviderAdapterFactory;
import org.eclipse.fordiac.ide.systemmanagement.ui.systemexplorer.StyledSystemLabelProvider;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.widget.SelectionTabbedPropertySheetPage;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class AutomationSystemEditor
extends AbstractBreadCrumbEditor
implements ITypeEntryEditor {
    private AutomationSystem system;
    private DiagramOutlinePage outlinePage;
    private final EditorTabCommandStackListener subEditorCommandStackListener = new EditorTabCommandStackListener((INavigationLocationProvider)this);
    private GraphicalAnnotationModel annotationModel;
    private ValidationJob validationJob;
    private TypeEntryAdapter typeEntryAdapter;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.typeEntryAdapter = new TypeEntryAdapter((ITypeEntryEditor)this, site.getWorkbenchWindow().getPartService());
        super.init(site, input);
    }

    public void createPartControl(Composite parent) {
        if (this.system != null) {
            super.createPartControl(parent);
        } else {
            this.showLoadErrorMessage(parent);
        }
    }

    public void showLoadErrorMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)composite);
        Image image = Display.getDefault().getSystemImage(1);
        Label imageLabel = new Label(composite, 0);
        image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)imageLabel);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(MessageFormat.format(Messages.AutomationSystemEditor_CouldNotLoadSystem, this.getEditorInput().getName()));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)messageLabel);
    }

    public String getTitleToolTip() {
        String tooltip = this.system != null ? this.system.getTypeEntry().getFullTypeName() + "\n" : "";
        return tooltip + super.getTitleToolTip();
    }

    protected Composite createPageContainer(Composite parent) {
        Composite pageContainer = new Composite(parent, 0);
        pageContainer.setLayoutData((Object)new GridData(1808));
        return pageContainer;
    }

    protected void addPages() {
        try {
            int pagenum = this.addPage((IEditorPart)new SystemEditor(), this.getEditorInput());
            this.getModelToEditorNumMapping().put(this.system, pagenum);
        }
        catch (PartInitException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (-1 != newPageIndex && this.outlinePage != null) {
            GraphicalViewer viewer = (GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class);
            this.outlinePage.viewerChanged(viewer);
        }
    }

    protected EditorPart createEditorPart(Object model) {
        if (model instanceof IFile) {
            return new SystemEditor();
        }
        if (model instanceof CFBInstance) {
            return new CompositeInstanceViewer();
        }
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped() || subApp.isContainedInTypedInstance()) {
                return new SubappInstanceViewer();
            }
            return new SubAppNetworkEditor();
        }
        if (model instanceof Application) {
            return new ApplicationEditor();
        }
        if (model instanceof SystemConfiguration) {
            return new SystemConfigurationEditor();
        }
        if (model instanceof Device) {
            return new SystemConfigurationEditor();
        }
        if (model instanceof Resource) {
            return new ResourceDiagramEditor();
        }
        return null;
    }

    protected IEditorInput createEditorInput(Object model) {
        if (model instanceof IFile) {
            return this.getEditorInput();
        }
        if (model instanceof SubApp) {
            SubApp subApp = (SubApp)model;
            if (subApp.isTyped() || subApp.isContainedInTypedInstance()) {
                return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)subApp);
            }
            return new SubApplicationEditorInput(subApp);
        }
        if (model instanceof CFBInstance) {
            return new CompositeAndSubAppInstanceViewerInput((FBNetworkElement)((FB)model));
        }
        if (model instanceof Application) {
            Application app = (Application)model;
            return new ApplicationEditorInput(app);
        }
        if (model instanceof SystemConfiguration) {
            SystemConfiguration sysConf = (SystemConfiguration)model;
            return new SystemConfigurationEditorInput(sysConf);
        }
        if (model instanceof Device) {
            Device dev = (Device)model;
            return new SystemConfigurationEditorInput(dev.getSystemConfiguration());
        }
        if (model instanceof Resource) {
            Resource res = (Resource)model;
            return new ResourceEditorInput(res);
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.system != null) {
            block8: {
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.getFile().getParent()){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        AutomationSystemEditor.this.system.getTypeEntry().save((LibraryElement)AutomationSystemEditor.this.system, monitor);
                    }
                };
                try {
                    this.typeEntryAdapter.setBlockUpdates(true);
                    operation.run(monitor);
                }
                catch (InvocationTargetException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    this.typeEntryAdapter.setBlockUpdates(false);
                    break block8;
                }
                catch (InterruptedException e) {
                    try {
                        FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.typeEntryAdapter.setBlockUpdates(false);
                    }
                }
                this.typeEntryAdapter.setBlockUpdates(false);
            }
            this.getCommandStack().markSaveLocation();
        }
    }

    protected AdapterFactoryContentProvider createBreadcrumbContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)new AutomationSystemProviderAdapterFactory());
    }

    protected AdapterFactoryLabelProvider createBreadcrumbLabelProvider() {
        return new StyledSystemLabelProvider();
    }

    protected Object getInitialModel(String itemPath) {
        String searchPath;
        EObject targetmodel;
        String[] nameList;
        if (itemPath != null && (nameList = itemPath.split("\\.")).length > 1 && (targetmodel = FBNetworkHelper.getModelFromHierarchicalName((String)(searchPath = itemPath.substring(itemPath.indexOf(46) + 1)), (AutomationSystem)this.system)) != null) {
            return targetmodel;
        }
        return this.system;
    }

    public void doSaveAs() {
        if (this.system == null) {
            return;
        }
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalName(this.getFile().getName());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path == null) {
            return;
        }
        IPath fullPath = this.getFile().getFullPath();
        if (fullPath.equals((Object)path)) {
            this.doSave(null);
            return;
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)file.getParent()){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                TypeEntry oldSystemEntry = AutomationSystemEditor.this.system.getTypeEntry();
                AutomationSystemEditor.this.system.setName(TypeEntry.getTypeNameFromFile((IFile)file));
                TypeEntry newSystemEntry = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject()).createTypeEntry(file);
                newSystemEntry.save((LibraryElement)AutomationSystemEditor.this.system, monitor);
                oldSystemEntry.eAdapters().remove((Object)AutomationSystemEditor.this.typeEntryAdapter);
                oldSystemEntry.setType(null);
                AutomationSystemEditor.this.setInput((IEditorInput)new FileEditorInput(file));
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return adapter.cast(new SelectionTabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this));
        }
        if (adapter == IContentOutlinePage.class) {
            if (this.outlinePage == null && this.system != null) {
                this.outlinePage = new DiagramOutlinePage((GraphicalViewer)this.getActiveEditor().getAdapter(GraphicalViewer.class));
            }
            return adapter.cast(this.outlinePage);
        }
        if (adapter == AutomationSystem.class || adapter == LibraryElement.class) {
            return adapter.cast(this.system);
        }
        if (adapter == GraphicalAnnotationModel.class) {
            return adapter.cast(this.annotationModel);
        }
        if (adapter == TypeEntryAdapter.class) {
            return adapter.cast(this.typeEntryAdapter);
        }
        return (T)super.getAdapter(adapter);
    }

    public CommandStack getCommandStack() {
        return this.system != null ? this.system.getCommandStack() : null;
    }

    public String getContributorId() {
        return "org.eclipse.fordiac.ide.application.editors.DiagramEditor";
    }

    private IFile getFile() {
        return this.system.getTypeEntry().getFile();
    }

    public void dispose() {
        if (this.system != null && this.system.getTypeEntry() != null && this.system.getTypeEntry().eAdapters().contains((Object)this.typeEntryAdapter)) {
            this.system.getTypeEntry().eAdapters().remove((Object)this.typeEntryAdapter);
        }
        boolean dirty = this.isDirty();
        if (this.getCommandStack() != null) {
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this.subEditorCommandStackListener);
        }
        if (this.validationJob != null) {
            this.validationJob.dispose();
        }
        if (this.annotationModel != null) {
            this.annotationModel.dispose();
        }
        super.dispose();
        if (dirty && this.system != null) {
            ((SystemEntry)this.system.getTypeEntry()).setSystem(null);
            this.system = null;
        }
        this.typeEntryAdapter.dispose();
    }

    public void reloadType() {
        CommandStack commandStack = this.system.getCommandStack();
        String path = this.getBreadcrumb().serializePath();
        SystemEntry typeEntry = (SystemEntry)this.system.getTypeEntry();
        if (typeEntry.eAdapters().contains((Object)this.typeEntryAdapter)) {
            typeEntry.eAdapters().remove((Object)this.typeEntryAdapter);
        }
        typeEntry.setSystem(null);
        this.system = typeEntry.getSystem();
        this.system.setCommandStack(commandStack);
        this.getCommandStack().flush();
        typeEntry.eAdapters().add((Object)this.typeEntryAdapter);
        this.setPartName(this.system.getName());
        if (!this.getBreadcrumb().openPath(path, this.system)) {
            if (!this.system.getApplication().isEmpty()) {
                OpenListenerManager.openEditor((EObject)((EObject)this.system.getApplication().get(0)));
                this.showReloadErrorMessage(path, Messages.AutomationSystemEditor_ShowingFirstApplication);
            } else {
                OpenListenerManager.openEditor((EObject)this.system);
                this.showReloadErrorMessage(path, Messages.AutomationSystemEditor_ShowingSystem);
            }
        }
        this.selectRootModelOfEditor();
    }

    public void setInput(IEditorInput input) {
        if (this.validationJob != null) {
            this.validationJob.dispose();
            this.validationJob = null;
        }
        if (this.annotationModel != null) {
            this.annotationModel.dispose();
            this.annotationModel = null;
        }
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEI = (FileEditorInput)input;
            if (this.getEditorInput() == null) {
                this.system = SystemManager.INSTANCE.getSystem(fileEI.getFile());
                if (this.system != null) {
                    this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
                    this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this.subEditorCommandStackListener);
                    QualNameChangeListenerManager.addCommandStackEventListener((CommandStack)this.getCommandStack());
                    this.system.getTypeEntry().eAdapters().add((Object)this.typeEntryAdapter);
                }
            }
            this.setPartName(TypeEntry.getTypeNameFromFile((IFile)fileEI.getFile()));
            this.annotationModel = new FordiacMarkerGraphicalAnnotationModel((IResource)fileEI.getFile(), () -> this.system);
            this.validationJob = new ValidationJob(this.getPartName(), this.getCommandStack(), this.annotationModel);
            this.pages.stream().filter(IReusableEditor.class::isInstance).map(IReusableEditor.class::cast).forEach(e -> e.setInput(e.getEditorInput()));
        }
        this.setInputWithNotify(input);
    }

    private void selectRootModelOfEditor() {
        Display.getDefault().asyncExec(() -> {
            GraphicalViewer viewer = this.getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                Object selection = this.getSelection(viewer);
                EditorUtils.refreshPropertySheetWithSelection((IEditorPart)this, (EditPartViewer)viewer, (Object)selection);
            }
        });
    }

    private Object getSelection(GraphicalViewer viewer) {
        RootEditPart selection = null;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof DiagramEditorWithFlyoutPalette) {
            DiagramEditorWithFlyoutPalette diagramEditor = (DiagramEditorWithFlyoutPalette)activeEditor;
            selection = viewer.getEditPartForModel(diagramEditor.getModel());
        }
        if (selection == null) {
            selection = viewer.getRootEditPart();
        }
        return selection;
    }
}

