/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class FordiacKeywords {
    public static final Set<String> RESERVED_ST_KEYWORDS = FordiacKeywords.getKeywordsOfType(KeywordTypes.STRUCTURED_TEXT);
    public static final Set<String> RESERVED_DATATYPE_KEYWORDS = FordiacKeywords.getKeywordsOfType(KeywordTypes.DATATYPE);
    public static final Set<String> RESERVED_DATATYPE_CLASS_KEYWORDS = FordiacKeywords.getKeywordsOfType(KeywordTypes.DATATYPE_CLASS);
    public static final Set<String> RESERVED_TIME_UNIT_KEYWORDS = FordiacKeywords.getKeywordsOfType(KeywordTypes.TIME_UNIT);
    public static final Set<String> RESERVED_KEYWORDS = Stream.of(RESERVED_ST_KEYWORDS, RESERVED_DATATYPE_KEYWORDS, RESERVED_DATATYPE_CLASS_KEYWORDS, RESERVED_TIME_UNIT_KEYWORDS).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    public static final Map<String, AllowedContexts> ALLOWED_CONTEXTS = Stream.of(FordiacKeywords.class.getDeclaredFields()).filter(f -> f.getAnnotation(AllowedContexts.class) != null && f.getAnnotation(AllowedContexts.class).value() != null).collect(Collectors.toUnmodifiableMap(FordiacKeywords::getName, FordiacKeywords::getAllowedContexts));
    public static final String ANY_ADAPTER = "ANY_ADAPTER";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DATE = "ANY_DATE";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_STRING = "ANY_STRING";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_BIT = "ANY_BIT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_REAL = "ANY_REAL";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_INT = "ANY_INT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_NUM = "ANY_NUM";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_MAGNITUDE = "ANY_MAGNITUDE";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_ELEMENTARY = "ANY_ELEMENTARY";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY = "ANY";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_STRUCT = "ANY_STRUCT";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DERIVED = "ANY_DERIVED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_SIGNED = "ANY_SIGNED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_UNSIGNED = "ANY_UNSIGNED";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_DURATION = "ANY_DURATION";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_CHAR = "ANY_CHAR";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_CHARS = "ANY_CHARS";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_SCHARS = "ANY_SCHARS";
    @Keyword(value=KeywordTypes.DATATYPE_CLASS)
    public static final String ANY_WCHARS = "ANY_WCHARS";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DINT = "DINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String INT = "INT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String SINT = "SINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LINT = "LINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String UINT = "UINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String USINT = "USINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String UDINT = "UDINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String ULINT = "ULINT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String REAL = "REAL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LREAL = "LREAL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String STRING = "STRING";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WSTRING = "WSTRING";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String CHAR = "CHAR";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WCHAR = "WCHAR";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String ANY_TIME = "ANY_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TIME = "TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTIME = "LTIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TIME_OF_DAY = "TIME_OF_DAY";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTIME_OF_DAY = "LTIME_OF_DAY";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String TOD = "TOD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LTOD = "LTOD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DATE = "DATE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDATE = "LDATE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DATE_AND_TIME = "DATE_AND_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    @AllowedContexts(value={VarDeclaration.class})
    public static final String DT = "DT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDATE_AND_TIME = "LDATE_AND_TIME";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LDT = "LDT";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String BOOL = "BOOL";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String BYTE = "BYTE";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String WORD = "WORD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String DWORD = "DWORD";
    @Keyword(value=KeywordTypes.DATATYPE)
    public static final String LWORD = "LWORD";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    @AllowedContexts(value={VarDeclaration.class})
    public static final String DAY = "D";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String HOUR = "H";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MINUTE = "M";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    @AllowedContexts(value={VarDeclaration.class, Event.class})
    public static final String SECOND = "S";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MILLISECOND = "MS";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String MICROSECOND = "US";
    @Keyword(value=KeywordTypes.TIME_UNIT)
    public static final String NANOSECOND = "NS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ABS = "ABS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ABSTRACT = "ABSTRACT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ACOS = "ACOS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ACTION = "ACTION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ADD = "ADD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ALGORITHM = "ALGORITHM";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String AND = "AND";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ARRAY = "ARRAY";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ASIN = "ASIN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String AT = "AT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ATAN = "ATAN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ATAN2 = "ATAN2";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String BY = "BY";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CASE = "CASE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CLASS = "CLASS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONCAT = "CONCAT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONFIGURATION = "CONFIGURATION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONSTANT = "CONSTANT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CONTINUE = "CONTINUE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String COS = "COS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CTD = "CTD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CTU = "CTU";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String CTUD = "CTUD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String DELETE = "DELETE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String DIV = "DIV";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String DO = "DO";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXPONENT = "E";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ELSE = "ELSE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ELSIF = "ELSIF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_ACTION = "END_ACTION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_ALGORITHM = "END_ALGORITHM";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_CASE = "END_CASE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_CLASS = "END_CLASS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_CONFIGURATION = "END_CONFIGURATION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_FOR = "END_FOR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_FUNCTION = "END_FUNCTION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_FUNCTION_BLOCK = "END_FUNCTION_BLOCK";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_INTERFACE = "END_INTERFACE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_IF = "END_IF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_METHOD = "END_METHOD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_NAMESPACE = "END_NAMESPACE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_PROGRAM = "END_PROGRAM";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_REPEAT = "END_REPEAT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_RESOURCE = "END_RESOURCE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_STEP = "END_STEP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_STRUCT = "END_STRUCT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_TRANSITION = "END_TRANSITION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_TYPE = "END_TYPE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_VAR = "END_VAR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String END_WHILE = "END_WHILE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EQ = "EQ";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXIT = "EXIT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXP = "EXP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXPT = "EXPT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String EXTENDS = "EXTENDS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String F_EDGE = "F_EDGE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String F_TRIG = "F_TRIG";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FALSE = "FALSE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FINAL = "FINAL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FIND = "FIND";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FOR = "FOR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FROM = "FROM";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FUNCTION = "FUNCTION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String FUNCTION_BLOCK = "FUNCTION_BLOCK";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String GE = "GE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String GT = "GT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String IF = "IF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String IMPLEMENTS = "IMPLEMENTS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String INITIAL_STEP = "INITIAL_STEP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String INSERT = "INSERT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String INTERFACE = "INTERFACE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String INTERNAL = "INTERNAL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String INTERVAL = "INTERVAL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LE = "LE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LT = "LT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LEFT = "LEFT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LEN = "LEN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LIMIT = "LIMIT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LN = "LN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String LOG = "LOG";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MAX = "MAX";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String METHOD = "METHOD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MID = "MID";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MIN = "MIN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MOD = "MOD";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MOVE = "MOVE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MUL = "MUL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String MUX = "MUX";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NAMESPACE = "NAMESPACE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NE = "NE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NON_RETAIN = "NON_RETAIN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NOT = "NOT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String NULL = "NULL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OF = "OF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ON = "ON";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OR = "OR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OVERLAP = "OVERLAP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String OVERRIDE = "OVERRIDE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String PRIORITY = "PRIORITY";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String PRIVATE = "PRIVATE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String PROGRAM = "PROGRAM";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String PROTECTED = "PROTECTED";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String PUBLIC = "PUBLIC";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String R_EDGE = "R_EDGE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String R_TRIG = "R_TRIG";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String READ_ONLY = "READ_ONLY";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String READ_WRITE = "READ_WRITE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String REF = "REF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String REF_TO = "REF_TO";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String REPEAT = "REPEAT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String REPLACE = "REPLACE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    @AllowedContexts(value={ServiceInterface.class})
    public static final String RESOURCE = "RESOURCE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String RETAIN = "RETAIN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String RETURN = "RETURN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String RIGHT = "RIGHT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ROL = "ROL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String ROR = "ROR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String RS = "RS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SEL = "SEL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SHL = "SHL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SHR = "SHR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SIN = "SIN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SINGLE = "SINGLE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SQRT = "SQRT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SR = "SR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String STEP = "STEP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String STRUCT = "STRUCT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SUB = "SUB";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String SUPER = "SUPER";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String T = "T";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TAN = "TAN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TASK = "TASK";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String THEN = "THEN";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String THIS = "THIS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TO = "TO";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TOF = "TOF";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TON = "TON";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TP = "TP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TRANSITION = "TRANSITION";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TRUE = "TRUE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TRUNC = "TRUNC";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String TYPE = "TYPE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String UNTIL = "UNTIL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String USING = "USING";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR = "VAR";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_ACCESS = "VAR_ACCESS";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_CONFIG = "VAR_CONFIG";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_EXTERNAL = "VAR_EXTERNAL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_GLOBAL = "VAR_GLOBAL";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_INPUT = "VAR_INPUT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_IN_OUT = "VAR_IN_OUT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_OUTPUT = "VAR_OUTPUT";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String VAR_TEMP = "VAR_TEMP";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String WHILE = "WHILE";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String WITH = "WITH";
    @Keyword(value=KeywordTypes.STRUCTURED_TEXT)
    public static final String XOR = "XOR";
    @ModelString
    public static final String VARIABLE_INTERNAL = "InternalVar1";
    @ModelString
    public static final String VARIABLE_INTERNAL_CONST = "InternalConstVar1";
    @ModelString
    public static final String EVENT_INPUT = "EI1";
    @ModelString
    public static final String EVENT_OUTPUT = "EO1";
    @ModelString
    public static final String DATA_INPUT = "DI1";
    @ModelString
    public static final String DATA_OUTPUT = "DO1";
    @ModelString
    public static final String ADAPTER_SOCKET = "SOCKET1";
    @ModelString
    public static final String ADAPTER_PLUG = "PLUG1";
    @ModelString
    public static final String VARINOUT = "VARINOUT1";
    @ModelString
    public static final String INTERFACE_Y_POSITION = "YPOSITION";

    private FordiacKeywords() {
        throw new UnsupportedOperationException();
    }

    private static String getName(Field f) {
        try {
            return (String)f.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            FordiacLogHelper.logError((String)"Exception in keyword access", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static AllowedContexts getAllowedContexts(Field f) {
        try {
            return f.getAnnotation(AllowedContexts.class);
        }
        catch (IllegalArgumentException e) {
            FordiacLogHelper.logError((String)"Exception in allowed context access", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static Set<String> getKeywordsOfType(KeywordTypes type) {
        return List.of(FordiacKeywords.class.getDeclaredFields()).stream().filter(field -> FordiacKeywords.isKeyword(field) && field.getAnnotation(Keyword.class).value() == type).map(FordiacKeywords::getName).collect(Collectors.toUnmodifiableSet());
    }

    public static boolean isReservedKeyword(String nameProposal) {
        return RESERVED_KEYWORDS.contains(nameProposal.toUpperCase());
    }

    public static boolean isReservedKeyword(String name, Object context) {
        if (context == null) {
            return FordiacKeywords.isReservedKeyword(name);
        }
        String upperCaseName = name.toUpperCase();
        return RESERVED_KEYWORDS.contains(upperCaseName) && !FordiacKeywords.matchesAllowedContext(upperCaseName, context);
    }

    private static boolean isKeyword(Field field) {
        return field.getType().equals(String.class) && field.isAnnotationPresent(Keyword.class);
    }

    private static boolean matchesAllowedContext(String upperCaseName, Object context) {
        AllowedContexts allowedContexts = ALLOWED_CONTEXTS.get(upperCaseName);
        return allowedContexts != null && Stream.of(allowedContexts.value()).anyMatch(value -> value.isAssignableFrom(context.getClass()));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface AllowedContexts {
        public Class<?>[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface Keyword {
        public KeywordTypes value();
    }

    public static enum KeywordTypes {
        DATATYPE,
        DATATYPE_CLASS,
        TIME_UNIT,
        STRUCTURED_TEXT;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface ModelString {
    }
}

