/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.errormarker;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public final class FordiacErrorMarker {
    public static final String PROBLEM_MARKER = "org.eclipse.fordiac.ide.model.problem";
    public static final String IEC61499_MARKER = "org.eclipse.fordiac.ide.model.iec61499";
    public static final String VALIDATION_MARKER = "org.eclipse.fordiac.ide.model.validation";
    public static final String INITIAL_VALUE_MARKER = "org.eclipse.fordiac.ide.model.initialValue";
    public static final String TYPE_DECLARATION_MARKER = "org.eclipse.fordiac.ide.model.typeDeclaration";
    public static final String CONDITION_EXPRESSION_MARKER = "org.eclipse.fordiac.ide.model.conditionExpression";
    public static final String IMPORT_MARKER = "org.eclipse.fordiac.ide.model.import";
    public static final String UNUSED_MARKER = "org.eclipse.fordiac.ide.model.unused";
    public static final String TYPE_LIBRARY_MARKER = "org.eclipse.fordiac.ide.model.typeLibrary";
    public static final String PROJECT_CONFIGURATION_MARKER = "org.eclipse.fordiac.ide.model.projectConfiguration";
    public static final String LIBRARY_MARKER = "org.eclipse.fordiac.ide.model.library";
    public static final String TEMPORARY_MARKER = "org.eclipse.fordiac.ide.model.temporary";
    private static final Set<String> MODEL_MARKER_TYPES = Set.of("org.eclipse.fordiac.ide.model.iec61499", "org.eclipse.fordiac.ide.model.validation", "org.eclipse.fordiac.ide.model.initialValue", "org.eclipse.fordiac.ide.model.typeDeclaration", "org.eclipse.fordiac.ide.model.conditionExpression", "org.eclipse.fordiac.ide.model.import", "org.eclipse.fordiac.ide.model.unused", "org.eclipse.fordiac.ide.model.typeLibrary", "org.eclipse.fordiac.ide.model.projectConfiguration", "org.eclipse.fordiac.ide.model.library", "org.eclipse.fordiac.ide.model.temporary");
    public static final String CODE = "org.eclipse.fordiac.ide.model.iec61499.code";
    public static final String SOURCE = "org.eclipse.fordiac.ide.model.iec61499.source";
    public static final String TARGET_URI = "org.eclipse.fordiac.ide.model.iec61499.targetUri";
    public static final String TARGET_TYPE = "org.eclipse.fordiac.ide.model.iec61499.targetType";
    public static final String TARGET_FEATURE = "org.eclipse.fordiac.ide.model.iec61499.targetFeature";
    public static final String DATA = "org.eclipse.fordiac.ide.model.iec61499.data";
    public static final int DEFAULT_CODE = 0;

    public static boolean isModelMarkerType(String markerType) {
        return MODEL_MARKER_TYPES.contains(markerType);
    }

    public static int getCode(IMarker marker) {
        return marker.getAttribute(CODE, 0);
    }

    public static String getSource(IMarker marker) {
        return marker.getAttribute(SOURCE, null);
    }

    public static String[] getData(IMarker marker) {
        return marker.getAttribute(DATA, "").split("\u0000");
    }

    public static URI getTargetUri(IMarker marker) {
        String targetUriAttribute = marker.getAttribute(TARGET_URI, null);
        if (targetUriAttribute != null) {
            return URI.createURI((String)targetUriAttribute);
        }
        return null;
    }

    public static EClass getTargetType(IMarker marker) {
        Resource eResource;
        URI targetTypeUri;
        EPackage ePackage;
        String targetTypeAttribute = marker.getAttribute(TARGET_TYPE, null);
        if (targetTypeAttribute != null && (ePackage = EPackage.Registry.INSTANCE.getEPackage((targetTypeUri = URI.createURI((String)targetTypeAttribute)).trimFragment().toString())) != null && (eResource = ePackage.eResource()) != null) {
            return (EClass)eResource.getEObject(targetTypeUri.fragment());
        }
        return null;
    }

    public static EStructuralFeature getTargetFeature(IMarker marker) {
        Resource eResource;
        URI targetFeatureUri;
        EPackage ePackage;
        String targetFeatureAttribute = marker.getAttribute(TARGET_FEATURE, null);
        if (targetFeatureAttribute != null && (ePackage = EPackage.Registry.INSTANCE.getEPackage((targetFeatureUri = URI.createURI((String)targetFeatureAttribute)).trimFragment().toString())) != null && (eResource = ePackage.eResource()) != null) {
            return (EStructuralFeature)eResource.getEObject(targetFeatureUri.fragment());
        }
        return null;
    }

    public static EObject getTarget(IMarker marker) {
        URI targetUri = FordiacErrorMarker.getTargetUri(marker);
        if (targetUri != null && targetUri.isPlatformResource()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return resourceSet.getEObject(targetUri, true);
        }
        return null;
    }

    @Deprecated(since="3.0.0", forRemoval=true)
    public static EObject getTargetEditable(IMarker marker) {
        URI targetUri = FordiacErrorMarker.getTargetUri(marker);
        if (targetUri != null) {
            Resource resource;
            TypeEntry typeEntry;
            IFile file;
            if (targetUri.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetUri.toPlatformString(true)))).exists() && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file)) != null && (resource = typeEntry.getTypeEditable().eResource()) != null) {
                return resource.getEObject(targetUri.fragment());
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return resourceSet.getEObject(targetUri, true);
        }
        return null;
    }

    public static EObject getTargetRelative(IMarker marker, LibraryElement root) {
        SegmentSequence segments;
        URI targetUri = FordiacErrorMarker.getTargetUri(marker);
        if (targetUri != null && (segments = SegmentSequence.create((String)"/", (String)targetUri.fragment())).segmentCount() > 2) {
            String relativeFragment = String.join((CharSequence)"/", segments.subSegments(2));
            return EcoreUtil.getEObject((EObject)root, (String)relativeFragment);
        }
        return null;
    }

    public static boolean markerTargetsFBNetworkElement(IMarker marker) {
        return FordiacErrorMarker.isTargetOfType(marker, LibraryElementPackage.eINSTANCE.getFBNetworkElement());
    }

    public static boolean markerTargetsErrorMarkerInterface(IMarker marker) {
        return FordiacErrorMarker.isTargetOfType(marker, LibraryElementPackage.eINSTANCE.getErrorMarkerInterface());
    }

    public static boolean markerTargetsConnection(IMarker marker) {
        return FordiacErrorMarker.isTargetOfType(marker, LibraryElementPackage.eINSTANCE.getConnection());
    }

    public static boolean markerTargetsValue(IMarker marker) {
        return FordiacErrorMarker.isTargetOfType(marker, LibraryElementPackage.eINSTANCE.getValue());
    }

    public static boolean isTargetOfType(IMarker marker, EClass type) {
        EClass targetType = FordiacErrorMarker.getTargetType(marker);
        if (targetType != null) {
            return type.isSuperTypeOf(targetType);
        }
        return false;
    }

    private FordiacErrorMarker() {
        throw new UnsupportedOperationException();
    }
}

