/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Compiler;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractTypeExporter
extends CommonElementExporter {
    private final LibraryElement type;

    protected AbstractTypeExporter(LibraryElement type) {
        this.type = type;
    }

    protected AbstractTypeExporter(CommonElementExporter parent) {
        super(parent);
        this.type = null;
    }

    public LibraryElement getType() {
        return this.type;
    }

    public InputStream getFileContent() {
        try {
            this.createXMLEntries();
            this.getWriter().writeCharacters("\n");
            this.getWriter().writeEndDocument();
            this.getWriter().close();
            CommonElementExporter.ByteBufferInputStream byteBufferInputStream = new CommonElementExporter.ByteBufferInputStream(this.getOutputStream().transferDataBuffers());
            return byteBufferInputStream;
        }
        catch (XMLStreamException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.getOutputStream().close();
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected void createXMLEntries() throws XMLStreamException {
        this.createNamedElementEntry(this.getType(), this.getRootTag());
        this.addIdentification(this.getType());
        this.addVersionInfo(this.getType());
        this.createTypeSpecificXMLEntries();
        this.addEndElement();
    }

    protected abstract String getRootTag();

    protected abstract void createTypeSpecificXMLEntries() throws XMLStreamException;

    protected void addCompilerInfo(CompilerInfo compilerInfo) throws XMLStreamException {
        if (compilerInfo != null) {
            this.addStartElement("CompilerInfo");
            if (compilerInfo.getHeader() != null && !"".equals(compilerInfo.getHeader())) {
                this.getWriter().writeAttribute("header", compilerInfo.getHeader());
            }
            if (compilerInfo.getClassdef() != null && !"".equals(compilerInfo.getClassdef())) {
                this.getWriter().writeAttribute("classdef", compilerInfo.getClassdef());
            }
            if (compilerInfo.getPackageName() != null && !"".equals(compilerInfo.getPackageName())) {
                this.getWriter().writeAttribute("packageName", compilerInfo.getPackageName());
            }
            for (Import imp : compilerInfo.getImports()) {
                this.addImport(imp);
            }
            for (Compiler compiler : compilerInfo.getCompiler()) {
                this.addCompiler(compiler);
            }
            this.addEndElement();
        }
    }

    private void addCompiler(Compiler compiler) throws XMLStreamException {
        this.addEmptyStartElement("Compiler");
        this.getWriter().writeAttribute("Language", compiler.getLanguage() != null ? compiler.getLanguage().getName() : "");
        this.getWriter().writeAttribute("Vendor", compiler.getVendor() != null ? compiler.getVendor() : "");
        this.getWriter().writeAttribute("Product", compiler.getProduct() != null ? compiler.getProduct() : "");
        this.getWriter().writeAttribute("Version", compiler.getVersion() != null ? compiler.getVersion() : "");
    }

    private void addImport(Import imp) throws XMLStreamException {
        this.addEmptyStartElement("Import");
        this.getWriter().writeAttribute("declaration", imp.getImportedNamespace() != null ? imp.getImportedNamespace() : "");
    }

    protected void addVarDeclaration(VarDeclaration varDecl) throws XMLStreamException {
        boolean hasAttributes;
        boolean bl = hasAttributes = !varDecl.getAttributes().isEmpty() || varDecl.isInOutVar() && !varDecl.getInOutVarOpposite().getAttributes().isEmpty();
        if (hasAttributes) {
            this.addStartElement("VarDeclaration");
        } else {
            this.addEmptyStartElement("VarDeclaration");
        }
        this.addNameTypeCommentAttribute(varDecl, varDecl.getType());
        if (varDecl.isArray()) {
            this.getWriter().writeAttribute("ArraySize", ArraySizeHelper.getArraySize(varDecl));
        }
        if (varDecl.getValue() != null && !varDecl.getValue().getValue().isEmpty()) {
            this.getWriter().writeAttribute("InitialValue", varDecl.getValue().getValue());
        }
        if (hasAttributes) {
            if (varDecl.isInOutVar() && !varDecl.getInOutVarOpposite().isVisible()) {
                this.addAttributeElement("VisibleOutSide", null, "false", null);
            }
            this.addAttributes((EList<Attribute>)varDecl.getAttributes());
            this.addEndElement();
        }
    }
}

