/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.LibraryElementSearchContext;
import org.eclipse.fordiac.ide.model.search.types.SearchChildrenProviderHelper;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;

public class AdapterTypeInstanceSearch
extends IEC61499ElementSearch {
    public AdapterTypeInstanceSearch(LibraryElement typeEditable, AdapterTypeEntry adpEntry) {
        super(new LibraryElementSearchContext(typeEditable), AdapterTypeInstanceSearch.createSearchFilter(adpEntry), new DataTypeInstanceSearchChildrenProvider());
    }

    private static IEC61499SearchFilter createSearchFilter(AdapterTypeEntry adpEntry) {
        return searchCandidate -> {
            AdapterDeclaration adpDecl;
            return searchCandidate instanceof AdapterDeclaration && adpEntry == (adpDecl = (AdapterDeclaration)searchCandidate).getType().getTypeEntry();
        };
    }

    private static final class DataTypeInstanceSearchChildrenProvider
    implements ISearchChildrenProvider {
        private DataTypeInstanceSearchChildrenProvider() {
        }

        @Override
        public boolean hasChildren(EObject obj) {
            return obj instanceof FBType || obj instanceof AutomationSystem || obj instanceof UntypedSubApp || obj instanceof Application || obj instanceof FBNetworkElement;
        }

        @Override
        public Stream<? extends EObject> getChildren(EObject obj) {
            if (obj instanceof FBType) {
                FBType fbType = (FBType)obj;
                return DataTypeInstanceSearchChildrenProvider.getFBTypeChildren(fbType);
            }
            if (obj instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)obj;
                return system.getApplication().stream();
            }
            if (obj instanceof Application) {
                Application application = (Application)obj;
                return application.getFBNetwork().getNetworkElements().stream();
            }
            if (obj instanceof UntypedSubApp) {
                UntypedSubApp untypedSubapp = (UntypedSubApp)obj;
                return DataTypeInstanceSearchChildrenProvider.getUntypedSubappChildren(untypedSubapp);
            }
            if (obj instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement elem = (BlockFBNetworkElement)obj;
                return Stream.concat(elem.getAttributes().stream(), SearchChildrenProviderHelper.getInterfaceListChildren(elem.getInterface()));
            }
            return Stream.empty();
        }

        private static Stream<AdapterDeclaration> getInterfaceListChildren(InterfaceList interfaceList) {
            return Stream.concat(interfaceList.getSockets().stream(), interfaceList.getPlugs().stream());
        }

        private static Stream<? extends EObject> getFBTypeChildren(FBType fbType) {
            Stream<AdapterDeclaration> retval = DataTypeInstanceSearchChildrenProvider.getInterfaceListChildren(fbType.getInterfaceList());
            if (fbType instanceof SubAppType) {
                SubAppType subAppType = (SubAppType)fbType;
                retval = Stream.concat(retval, subAppType.getFBNetwork().getNetworkElements().stream());
            }
            return retval;
        }

        private static Stream<? extends EObject> getUntypedSubappChildren(UntypedSubApp untypedSubapp) {
            Stream<AdapterDeclaration> retval = DataTypeInstanceSearchChildrenProvider.getInterfaceListChildren(untypedSubapp.getInterface());
            retval = Stream.concat(retval, untypedSubapp.getSubAppNetwork().getNetworkElements().stream());
            return retval;
        }
    }
}

