/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit.helper;

import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class CommentHelper {
    public static boolean hasComment(INamedElement element) {
        return element != null && element.getComment() != null && !element.getComment().isBlank();
    }

    public static String getInstanceComment(INamedElement element) {
        if (CommentHelper.hasComment(element)) {
            return element.getComment();
        }
        if (element instanceof IInterfaceElement) {
            IInterfaceElement interfaceElement = (IInterfaceElement)element;
            return CommentHelper.getTypeComment(interfaceElement);
        }
        return "";
    }

    public static String getTypeComment(IInterfaceElement interfaceElement) {
        if (interfaceElement != null) {
            StructuredType struct;
            VarDeclaration structMember;
            StructManipulator structManipulator;
            DataType dataType;
            BlockFBNetworkElement fbn = interfaceElement.getBlockFBNetworkElement();
            if (fbn instanceof StructManipulator && (dataType = (structManipulator = (StructManipulator)fbn).getDataType()) instanceof StructuredType && (structMember = (VarDeclaration)(struct = (StructuredType)dataType).getMemberVariables().stream().filter(member -> interfaceElement.getName().equals(member.getName())).findFirst().orElse(null)) != null && structMember.getComment() != null) {
                return structMember.getComment();
            }
            IInterfaceElement typeElement = interfaceElement.findInTypeInterface();
            if (typeElement != null && typeElement.getComment() != null) {
                return typeElement.getComment();
            }
        }
        return "";
    }

    private CommentHelper() {
        throw new UnsupportedOperationException();
    }
}

