/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.utilities;

import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.preferences.PreferenceProvider;

public class MarginBoundsHelper {
    private int marginTopBottom = 0;
    private int marginLeftRight = 0;

    public void updateMargins(Object editPartModel) {
        PositionableElement posElement;
        EObject eObject;
        if (editPartModel instanceof PositionableElement && (eObject = EcoreUtil.getRootContainer((EObject)(posElement = (PositionableElement)editPartModel))) instanceof LibraryElement) {
            LibraryElement libElement = (LibraryElement)eObject;
            IProject project = libElement.getTypeEntry().getFile().getProject();
            this.marginLeftRight = MarginBoundsHelper.getDisplayMargin(project, "MarginLeftRight");
            this.marginTopBottom = MarginBoundsHelper.getDisplayMargin(project, "MarginTopBottom");
        }
    }

    private static int getDisplayMargin(IProject project, String modelPreferenceKey) {
        int modelMargin = PreferenceProvider.getInt((String)"org.eclipse.fordiac.ide.model", (String)modelPreferenceKey, (int)0, (IProject)project);
        return CoordinateConverter.INSTANCE.iec61499ToScreen((double)modelMargin * 100.0);
    }

    public void expandRectangle(Rectangle rectangle) {
        rectangle.expand(this.marginLeftRight, this.marginTopBottom);
    }
}

