/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.bootfile.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.fordiac.ide.deployment.bootfile.Messages;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.model.NamedElementComparator;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class DownloadSelectionTree
extends ContainerCheckedTreeViewer {
    private static final String DOWNLOAD_DEV_SELECTION = "DOWNLOAD_DEV_SELECTION";
    private static final String DOWNLOAD_DEV_MGRID = "DOWNLOAD_DEV_MGRID";
    private static final String DOWNLOAD_DEV_PROPERTIES = "DOWNLOAD_DEV_PROPERTIES";

    public DownloadSelectionTree(Composite parent, int style) {
        super(parent, style);
        this.getTree().setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(this.getTree(), 16384);
        column1.setText(Messages.DownloadSelectionTree_Selection);
        column1.setWidth(200);
        TreeColumn mgrIDColumn = new TreeColumn(this.getTree(), 16384);
        mgrIDColumn.setText(Messages.DownloadSelectionTree_MgrId);
        mgrIDColumn.setWidth(150);
        TreeColumn propertiesColumn = new TreeColumn(this.getTree(), 16384);
        propertiesColumn.setText(Messages.DownloadSelectionTree_Properties);
        propertiesColumn.setWidth(200);
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        ViewLabelProvider lp = new ViewLabelProvider();
        this.setLabelProvider((IBaseLabelProvider)new DownloadDecoratingLabelProvider((ILabelProvider)lp, decorator));
        this.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals(DownloadSelectionTree.DOWNLOAD_DEV_PROPERTIES) && element instanceof Device;
            }

            public Object getValue(Object element, String property) {
                if (DownloadSelectionTree.DOWNLOAD_DEV_PROPERTIES.equals(property)) {
                    return DownloadSelectionTree.getSelectedString(element);
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = new TextCellEditor();
        cellEditorArray[1] = new TextCellEditor();
        this.setCellEditors(cellEditorArray);
        this.setColumnProperties(new String[]{DOWNLOAD_DEV_SELECTION, DOWNLOAD_DEV_MGRID, DOWNLOAD_DEV_PROPERTIES});
    }

    private static String getSelectedString(Object element) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (VarDeclaration varDeclaration : ((Device)element).getVarDeclarations()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(varDeclaration.getName());
            buffer.append("=");
            buffer.append(varDeclaration.getValue() != null ? varDeclaration.getValue().getValue() : "");
        }
        buffer.append("]");
        return buffer.toString();
    }

    static class DownloadDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        public DownloadDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getText(element);
                }
                case 1: {
                    if (!(element instanceof Device)) break;
                    return DeploymentHelper.getMgrIDSafe((Device)((Device)element));
                }
                case 2: {
                    if (!(element instanceof Device)) break;
                    return DownloadSelectionTree.getSelectedString(element);
                }
            }
            return "";
        }
    }

    private static class ViewContentProvider
    implements ITreeContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).toArray();
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof Device) {
                return ((Device)child).eContainer();
            }
            if (child instanceof Resource) {
                return ((Resource)child).getDevice();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof AutomationSystem) {
                SystemConfiguration sysConf = ((AutomationSystem)parent).getSystemConfiguration();
                if (sysConf == null) {
                    return new Object[0];
                }
                ArrayList devList = new ArrayList(sysConf.getDevices());
                Collections.sort(devList, NamedElementComparator.INSTANCE);
                return devList.toArray();
            }
            if (parent instanceof Device) {
                ArrayList<Resource> resource = new ArrayList<Resource>();
                for (Resource res : ((Device)parent).getResource()) {
                    if (res.isDeviceTypeResource()) continue;
                    resource.add(res);
                }
                return resource.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof AutomationSystem) {
                return !((AutomationSystem)parent).getSystemConfiguration().getDevices().isEmpty();
            }
            if (parent instanceof Device) {
                return !((Device)parent).getResource().isEmpty();
            }
            return parent instanceof Resource;
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof AutomationSystem) {
                return ((AutomationSystem)obj).getName();
            }
            if (obj instanceof INamedElement) {
                return ((INamedElement)obj).getName();
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof AutomationSystem) {
                return FordiacImage.ICON_SYSTEM_CONFIGURATION.getImage();
            }
            if (obj instanceof Device) {
                return FordiacImage.ICON_DEVICE.getImage();
            }
            if (obj instanceof Resource) {
                Resource res = (Resource)obj;
                if (res.isDeviceTypeResource()) {
                    return FordiacImage.ICON_FIRMWARE_RESOURCE.getImage();
                }
                return FordiacImage.ICON_RESOURCE.getImage();
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

