/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.comparator.primitive.ShortComparator;
import org.eclipse.collections.api.block.function.primitive.BooleanShortToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteShortToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharShortToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleShortToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatShortToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntShortToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;

public interface ShortIterable
extends PrimitiveIterable {
    public ShortIterator shortIterator();

    public short[] toArray();

    default public short[] toArray(short[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(short var1);

    default public boolean containsAll(short ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (short item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        ShortSet set = this instanceof ShortSet ? (ShortSet)this : this.toSet();
        for (short item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(ShortIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        ShortSet set = this instanceof ShortSet ? (ShortSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(short ... source) {
        ShortIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof ShortSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(ShortIterable source) {
        ShortIterable outside = this;
        ShortIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof ShortSet) {
            ShortIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof ShortSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(short ... source) {
        ShortIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof ShortSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(ShortIterable source) {
        ShortIterable outside = this;
        ShortIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof ShortSet) {
            ShortIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof ShortSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure var1);

    default public ShortIterable tap(ShortProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public ShortIterable select(ShortPredicate var1);

    public ShortIterable reject(ShortPredicate var1);

    default public <R extends MutableShortCollection> R select(ShortPredicate predicate, R target) {
        this.each(each -> {
            if (predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    default public <R extends MutableShortCollection> R reject(ShortPredicate predicate, R target) {
        this.each(each -> {
            if (!predicate.accept(each)) {
                target.add(each);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(ShortToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(ShortToObjectFunction<? extends V> function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(ShortToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each -> {
            Iterable iterable = (Iterable)function.valueOf(each);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(ShortToBooleanFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(ShortToByteFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(ShortToCharFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(ShortToShortFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(ShortToIntFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(ShortToFloatFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(ShortToLongFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(ShortToDoubleFunction function, R target) {
        this.each(each -> target.add(function.valueOf(each)));
        return target;
    }

    public short detectIfNone(ShortPredicate var1, short var2);

    public int count(ShortPredicate var1);

    public boolean anySatisfy(ShortPredicate var1);

    public boolean allSatisfy(ShortPredicate var1);

    default public boolean noneSatisfy(ShortPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableShortList toList();

    public MutableShortSet toSet();

    public MutableShortBag toBag();

    public LazyShortIterable asLazy();

    public <T> T injectInto(T var1, ObjectShortToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanShortToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteShortToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharShortToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortShortToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntShortToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatShortToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongShortToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleShortToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each -> {
            result[0] = function.valueOf(result[0], each);
        });
        return result[0];
    }

    default public long reduceIfEmpty(LongShortToLongFunction accumulator, long defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public long reduce(LongShortToLongFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        long[] result = new long[1];
        this.each(each -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each);
            } else {
                seenOne[0] = true;
                result[0] = each;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<ShortIterable> chunk(int size) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public long sum();

    default public IntSummaryStatistics summaryStatistics() {
        IntSummaryStatistics stats = new IntSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public short max();

    public short maxIfEmpty(short var1);

    public short min();

    public short minIfEmpty(short var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public short[] toSortedArray();

    public MutableShortList toSortedList();

    default public MutableShortList toSortedList(ShortComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableShortList toSortedListBy(ShortToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableShortList toSortedListBy(ShortToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

