/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.impl.inject.ComponentConstructor;
import org.apache.felix.scr.impl.inject.ComponentMethods;
import org.apache.felix.scr.impl.inject.LifecycleMethod;
import org.apache.felix.scr.impl.inject.ReferenceMethods;
import org.apache.felix.scr.impl.inject.field.FieldMethods;
import org.apache.felix.scr.impl.inject.internal.ComponentConstructorImpl;
import org.apache.felix.scr.impl.inject.internal.DuplexReferenceMethods;
import org.apache.felix.scr.impl.inject.methods.ActivateMethod;
import org.apache.felix.scr.impl.inject.methods.BindMethods;
import org.apache.felix.scr.impl.inject.methods.DeactivateMethod;
import org.apache.felix.scr.impl.inject.methods.ModifiedMethod;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;

public class ComponentMethodsImpl<T>
implements ComponentMethods<T> {
    private LifecycleMethod m_activateMethod;
    private LifecycleMethod m_modifiedMethod;
    private LifecycleMethod m_deactivateMethod;
    private ComponentConstructor<T> m_constructor;
    private final Map<String, ReferenceMethods> bindMethodMap = new HashMap<String, ReferenceMethods>();

    @Override
    public synchronized void initComponentMethods(ComponentMetadata componentMetadata, Class<T> implementationObjectClass, ComponentLogger logger) {
        if (this.m_activateMethod != null) {
            return;
        }
        DSVersion dsVersion = componentMetadata.getDSVersion();
        boolean configurableServiceProperties = componentMetadata.isConfigurableServiceProperties();
        boolean supportsInterfaces = componentMetadata.isConfigureWithInterfaces();
        this.m_activateMethod = new ActivateMethod(componentMetadata.getActivate(), componentMetadata.isActivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_deactivateMethod = new DeactivateMethod(componentMetadata.getDeactivate(), componentMetadata.isDeactivateDeclared(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        this.m_modifiedMethod = new ModifiedMethod(componentMetadata.getModified(), implementationObjectClass, dsVersion, configurableServiceProperties, supportsInterfaces);
        for (ReferenceMetadata referenceMetadata : componentMetadata.getDependencies()) {
            String refName = referenceMetadata.getName();
            ArrayList<ReferenceMethods> methods = new ArrayList<ReferenceMethods>();
            if (referenceMetadata.getField() != null) {
                methods.add(new FieldMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties));
            }
            if (referenceMetadata.getBind() != null) {
                methods.add(new BindMethods(referenceMetadata, implementationObjectClass, dsVersion, configurableServiceProperties));
            }
            if (methods.isEmpty()) {
                this.bindMethodMap.put(refName, ReferenceMethods.NOPReferenceMethod);
                continue;
            }
            if (methods.size() == 1) {
                this.bindMethodMap.put(refName, (ReferenceMethods)methods.get(0));
                continue;
            }
            this.bindMethodMap.put(refName, new DuplexReferenceMethods(methods));
        }
        this.m_constructor = new ComponentConstructorImpl<T>(componentMetadata, implementationObjectClass, logger);
    }

    @Override
    public LifecycleMethod getActivateMethod() {
        return this.m_activateMethod;
    }

    @Override
    public LifecycleMethod getDeactivateMethod() {
        return this.m_deactivateMethod;
    }

    @Override
    public LifecycleMethod getModifiedMethod() {
        return this.m_modifiedMethod;
    }

    @Override
    public ReferenceMethods getBindMethods(String refName) {
        return this.bindMethodMap.get(refName);
    }

    @Override
    public ComponentConstructor<T> getConstructor() {
        return this.m_constructor;
    }
}

