/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.rename;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.xtext.ide.refactoring.IRenameNameValidator;
import org.eclipse.xtext.ide.refactoring.IRenameStrategy2;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.refactoring.RenameContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameProcessor;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.rename.ISimpleNameProvider;
import org.eclipse.xtext.util.IAcceptor;

public class RenameElementProcessor2
extends AbstractRenameProcessor {
    protected static final Logger LOG = Logger.getLogger(RenameElementProcessor2.class);
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IRenameNameValidator nameValidator;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private ISimpleNameProvider simpleNameProvider;
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private Provider<LtkIssueAcceptor> statusProvider;
    @Inject
    private IChangeSerializer changeSerializer;
    @Inject
    private IRenameStrategy2 renameStrategy;
    @Inject
    private ChangeConverter.Factory changeConverterFactory;
    private String newName;
    private IRenameElementContext renameElementContext;
    private IProject project;
    private ResourceSet resourceSet;
    private EObject target;
    private String originalName;
    private LtkIssueAcceptor status;
    private Change change;

    @Override
    public boolean initialize(IRenameElementContext renameElementContext) {
        this.renameElementContext = renameElementContext;
        this.status = (LtkIssueAcceptor)this.statusProvider.get();
        this.project = this.projectUtil.getProject(renameElementContext.getTargetElementURI().trimFragment());
        if (this.project == null) {
            URI targetElementURI = renameElementContext.getTargetElementURI();
            this.status.add(RefactoringIssueAcceptor.Severity.ERROR, "Cannot determine project from targetURI " + (targetElementURI != null ? targetElementURI.toString() : null), renameElementContext.getTargetElementURI());
            return false;
        }
        this.resourceSet = this.resourceSetProvider.get(this.project);
        this.target = this.resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (this.target == null) {
            this.status.add(RefactoringIssueAcceptor.Severity.ERROR, "Rename target does not exist", renameElementContext.getTargetElementURI());
        } else {
            this.originalName = this.simpleNameProvider.getSimpleName(this.target);
        }
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.status.getRefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RenameChange renameChange = new RenameChange(this.newName, this.renameElementContext.getTargetElementURI());
        RenameContext renameContext = new RenameContext(Arrays.asList(renameChange), this.resourceSet, this.changeSerializer, (RefactoringIssueAcceptor)this.status);
        this.renameStrategy.applyRename(renameContext);
        String name = "Rename " + this.originalName + " to " + this.newName;
        ChangeConverter changeConverter = this.changeConverterFactory.create(name, null, this.status);
        this.changeSerializer.applyModifications((IAcceptor)changeConverter);
        this.change = changeConverter.getChange();
        return this.status.getRefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.change;
    }

    public Object[] getElements() {
        return new Object[]{this.renameElementContext.getTargetElementURI()};
    }

    public String getIdentifier() {
        return this.languageName + ".renameProcessor2";
    }

    public String getProcessorName() {
        return "Rename element";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.renameElementContext, (RenameArguments)new RenameArguments(this.newName, true), (String[])new String[]{"org.eclipse.xtext.ui.shared.xtextNature"}, (SharableParticipants)sharedParticipants);
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public RefactoringStatus validateNewName(String newName) {
        LtkIssueAcceptor nameStatus = (LtkIssueAcceptor)this.statusProvider.get();
        this.nameValidator.validate(this.target, newName, (RefactoringIssueAcceptor)nameStatus);
        return nameStatus.getRefactoringStatus();
    }

    @Override
    public String getNewName() {
        return this.newName;
    }

    @Override
    public void setNewName(String newName) {
        this.newName = newName;
    }
}

