/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.FBTransaction;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.Transaction;
import org.eclipse.fordiac.ide.fb.interpreter.api.EventManagerFactory;
import org.eclipse.fordiac.ide.fb.interpreter.api.ServiceFactory;
import org.eclipse.fordiac.ide.fb.interpreter.api.TransactionFactory;
import org.eclipse.fordiac.ide.fb.interpreter.inputgenerator.InputGenerator;
import org.eclipse.fordiac.ide.fb.interpreter.mm.EventManagerUtils;
import org.eclipse.fordiac.ide.fb.interpreter.mm.ServiceSequenceUtils;
import org.eclipse.fordiac.ide.fb.interpreter.mm.VariableUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateOutputPrimitiveCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateTransactionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPartFactory;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.MinSpaceFreeformFigure;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;

public class ServiceSequenceAssignView
extends ViewPart {
    private static final String DEFAULT_SEQUENCE_NAME = "ServiceSequence";
    private static final int DEFAULT_SEQUENCE_NUM = 10;
    private GraphicalViewer viewer;
    private ActionRegistry actionRegistry;
    private FBType fbType;
    private Label lblHead;
    private Text textEvent;
    private Text textParam;
    private Text textName;
    private Group settingsGroup;
    private static final int MARGIN = 10;
    private boolean sequenceVisible = false;
    private ServiceSequence generatedSequence;
    private int count = 10;

    private static Composite createParentComposite(Composite parent) {
        Composite returnComposite = new Composite(parent, 2048);
        GridLayoutFactory.fillDefaults().generateLayout(returnComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)returnComposite);
        return returnComposite;
    }

    private static Composite createHeaderComposite(Composite parent) {
        Composite returnComposite = new Composite(parent, 2048);
        GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 10, 10).generateLayout(returnComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)returnComposite);
        return returnComposite;
    }

    private static Composite createSubheaderComposite(Composite parent) {
        Composite returnComposite = new Composite(parent, 4);
        GridLayoutFactory.fillDefaults().numColumns(11).generateLayout(returnComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)returnComposite);
        return returnComposite;
    }

    private static Composite createBodyComposite(Composite parent) {
        Composite returnComposite = new Composite(parent, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(returnComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)returnComposite);
        return returnComposite;
    }

    public void createPartControl(Composite parent) {
        Composite parentComposite = ServiceSequenceAssignView.createParentComposite(parent);
        Composite headerComposite = ServiceSequenceAssignView.createHeaderComposite(parentComposite);
        Composite bodyComposite = ServiceSequenceAssignView.createBodyComposite(parentComposite);
        bodyComposite.setVisible(this.sequenceVisible);
        this.settingsGroup = new Group(headerComposite, 1);
        this.settingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.settingsGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite subheaderComposite = ServiceSequenceAssignView.createSubheaderComposite((Composite)this.settingsGroup);
        subheaderComposite.setLayout((Layout)new GridLayout(11, false));
        subheaderComposite.setLayoutData((Object)new GridData(4, 0, true, true));
        LabelFactory.newLabel((int)0).text(Messages.ServiceSequenceAssignView_NAME).create((Widget)subheaderComposite);
        this.textName = (Text)TextFactory.newText((int)0).text(DEFAULT_SEQUENCE_NAME).create((Widget)subheaderComposite);
        this.textName.setLayoutData((Object)new GridData(4, 0, true, true));
        LabelFactory.newLabel((int)0).text(Messages.ServiceSequenceAssignView_INITIAL_EVENTS).create((Widget)subheaderComposite);
        this.textEvent = (Text)TextFactory.newText((int)0).create((Widget)subheaderComposite);
        this.textEvent.setLayoutData((Object)new GridData(4, 0, true, true));
        LabelFactory.newLabel((int)0).text(Messages.ServiceSequenceAssignView_INITIAL_PARAMETERS).create((Widget)subheaderComposite);
        this.textParam = (Text)TextFactory.newText((int)0).create((Widget)subheaderComposite);
        this.textParam.setLayoutData((Object)new GridData(4, 0, true, true));
        LabelFactory.newLabel((int)0).text(Messages.ServiceSequenceAssignView_EVENT_COUNT).create((Widget)subheaderComposite);
        Text numRandom = (Text)TextFactory.newText((int)0).text(String.valueOf(10)).create((Widget)subheaderComposite);
        numRandom.setLayoutData((Object)new GridData(4, 0, true, true));
        numRandom.addVerifyListener(e -> {
            char[] cArray = e.text.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c < '0' || c > '9') {
                    e.doit = false;
                    return;
                }
                ++n2;
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)numRandom);
        Button reloadBtn = (Button)ButtonFactory.newButton((int)8).text(Messages.ServiceSequenceAssignView_RELOAD).onSelect(x -> this.refreshGraphicalViewer()).create((Widget)subheaderComposite);
        reloadBtn.setLayoutData((Object)new GridData(0, 131072));
        GridDataFactory.fillDefaults().applyTo((Control)reloadBtn);
        Consumer<SelectionEvent> gen = x -> {
            try {
                this.count = Integer.parseInt(numRandom.getText());
            }
            catch (NumberFormatException e) {
                this.count = 10;
            }
            this.generatedSequence = this.getNext();
            this.sequenceVisible = true;
            this.refreshGraphicalViewer();
            subheaderComposite.redraw();
            bodyComposite.setVisible(this.sequenceVisible);
        };
        Button genBtn = (Button)ButtonFactory.newButton((int)8).text(Messages.ServiceSequenceAssignView_GENERATE_SEQUENCE).onSelect(gen).create((Widget)subheaderComposite);
        genBtn.setLayoutData((Object)new GridData(0, 131072));
        GridDataFactory.fillDefaults().applyTo((Control)genBtn);
        Composite viewerComposite = new Composite(bodyComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewerComposite);
        viewerComposite.setLayout((Layout)new FillLayout());
        Composite selectorComposite = new Composite(bodyComposite, 2048);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)selectorComposite);
        selectorComposite.setLayout((Layout)new GridLayout());
        Composite subselectorComposite = new Composite(selectorComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subselectorComposite);
        subselectorComposite.setLayout((Layout)new GridLayout());
        Button possibleBtn = (Button)ButtonFactory.newButton((int)8).text(Messages.ServiceSequenceAssignView_POSSIBLE).onSelect(x -> this.assignType("POSSIBLE", gen)).create((Widget)subselectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)possibleBtn);
        Button conditionalBtn = (Button)ButtonFactory.newButton((int)8).text("\u2753 " + Messages.ServiceSequenceAssignView_CONDITIONAL).onSelect(x -> this.assignType("CONDITIONAL", gen)).create((Widget)subselectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)conditionalBtn);
        Button alwaysBtn = (Button)ButtonFactory.newButton((int)8).text("\u2705 " + Messages.ServiceSequenceAssignView_ALWAYS).onSelect(x -> this.assignType("ALWAYS", gen)).create((Widget)subselectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)alwaysBtn);
        Button forbiddenBtn = (Button)ButtonFactory.newButton((int)8).text("\u26d4 " + Messages.ServiceSequenceAssignView_FORBIDDEN).onSelect(x -> this.assignType("FORBIDDEN", gen)).create((Widget)subselectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)forbiddenBtn);
        Button skipBtn = (Button)ButtonFactory.newButton((int)8).text(Messages.ServiceSequenceAssignView_SKIP).onSelect(x -> gen.accept(null)).create((Widget)selectorComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)skipBtn);
        this.createGraphicalViewer(viewerComposite);
        this.setTitleImage(FordiacImage.ICON_BASIC_FB.getImage());
    }

    private void assignType(String type, Consumer<SelectionEvent> gen) {
        this.generatedSequence.setServiceSequenceType(type);
        this.saveSequence();
        gen.accept(null);
    }

    private void createGraphicalViewer(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.configureGraphicalViewer();
        this.initializeGraphicalViewer();
        this.hookGraphicalViewer();
    }

    private void configureGraphicalViewer() {
        this.viewer.getControl().setBackground(ColorConstants.listBackground);
        ScalableFreeformRootEditPart root = this.createRootEditPart();
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditPartFactory(ServiceSequenceAssignView.getEditpartFactory());
        this.viewer.setContextMenu((MenuManager)new FordiacContextMenuProvider((EditPartViewer)this.viewer, root.getZoomManager(), this.getActionRegistry()));
    }

    private void initializeGraphicalViewer() {
        IEditorPart ep = this.getSite().getPage().getActiveEditor();
        this.fbType = (FBType)ep.getAdapter(FBType.class);
        if (this.fbType != null) {
            this.refreshGraphicalViewer();
            if (this.lblHead != null) {
                this.lblHead.setText(this.fbType.getName());
            }
            if (this.settingsGroup != null) {
                this.settingsGroup.setText(this.fbType.getName());
            }
        }
    }

    private void refreshGraphicalViewer() {
        if (this.fbType != null && this.generatedSequence != null) {
            FBType typeCopy = (FBType)EcoreUtil.copy((EObject)this.fbType);
            typeCopy.setService(ServiceFactory.createDefaultServiceModel());
            typeCopy.getService().getServiceSequence().set(0, (Object)this.generatedSequence);
            this.viewer.setContents((Object)typeCopy);
        }
    }

    private void hookGraphicalViewer() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void saveSequence() {
        CommandStack cs = (CommandStack)this.getSite().getPage().getActiveEditor().getAdapter(CommandStack.class);
        cs.execute((Command)new CreateServiceSequenceCommand(this.fbType.getService()));
        ServiceSequence sequence = (ServiceSequence)this.fbType.getService().getServiceSequence().get(this.fbType.getService().getServiceSequence().size() - 1);
        sequence.setName(NameRepository.createUniqueName((INamedElement)sequence, (String)(this.generatedSequence.getName() + "_1")));
        sequence.setComment(this.generatedSequence.getComment());
        for (ServiceTransaction genTransaction : this.generatedSequence.getServiceTransaction()) {
            cs.execute((Command)new CreateTransactionCommand(sequence));
            ServiceTransaction transaction = (ServiceTransaction)sequence.getServiceTransaction().get(sequence.getServiceTransaction().size() - 1);
            transaction.getInputPrimitive().setParameters(genTransaction.getInputPrimitive().getParameters());
            for (OutputPrimitive outP : genTransaction.getOutputPrimitive()) {
                boolean isLeftInterface = false;
                if (this.fbType.getService().getLeftInterface().getName().equals(outP.getInterface().getName())) {
                    isLeftInterface = true;
                }
                cs.execute((Command)new CreateOutputPrimitiveCommand(transaction, isLeftInterface));
                ((OutputPrimitive)transaction.getOutputPrimitive().get(transaction.getOutputPrimitive().size() - 1)).setEvent(outP.getEvent());
                ((OutputPrimitive)transaction.getOutputPrimitive().get(transaction.getOutputPrimitive().size() - 1)).setParameters(outP.getParameters());
            }
        }
        sequence.setServiceSequenceType(this.generatedSequence.getServiceSequenceType());
        sequence.setStartState(this.generatedSequence.getStartState());
    }

    public void setFocus() {
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            protected AbstractFreeformFigure createDrawingAreaContainer() {
                return new MinSpaceFreeformFigure();
            }
        };
    }

    private static EditPartFactory getEditpartFactory() {
        return new ServiceSequenceEditPartFactory(null);
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    private ServiceSequence getNext() {
        if (this.fbType != null) {
            ServiceSequence seq = LibraryElementFactory.eINSTANCE.createServiceSequence();
            String name = this.textName.getText();
            if (name == null || name.isBlank()) {
                name = DEFAULT_SEQUENCE_NAME;
            }
            seq.setName(name);
            List events = ServiceSequenceUtils.splitList((String)this.textEvent.getText());
            List parameters = ServiceSequenceUtils.splitList((String)this.textParam.getText());
            try {
                ServiceSequenceAssignView.setParameters(this.fbType, parameters);
                ServiceSequenceAssignView.runInterpreter(seq, events, this.fbType, this.count, parameters);
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
            seq.setStartState("START");
            return seq;
        }
        return null;
    }

    private static void runInterpreter(ServiceSequence seq, List<String> eventNames, FBType fbType, int count, List<String> parameters) {
        FBType typeCopy = (FBType)EcoreUtil.copy((EObject)fbType);
        List<Event> events = eventNames.stream().filter(s -> !s.isBlank()).map(name -> ServiceSequenceAssignView.findEvent(typeCopy, name)).filter(Objects::nonNull).toList();
        if (!events.isEmpty() && count > 0) {
            if (!parameters.isEmpty()) {
                ServiceSequenceAssignView.addToGenSequence(fbType, seq, events.subList(0, 1), false);
                ((ServiceTransaction)seq.getServiceTransaction().get(seq.getServiceTransaction().size() - 1)).getInputPrimitive().setParameters(ServiceSequenceAssignView.formatInputParameter(parameters));
                ServiceSequenceAssignView.addToGenSequence(fbType, seq, events.subList(1, events.size()), true);
            } else {
                ServiceSequenceAssignView.addToGenSequence(fbType, seq, events, true);
            }
        }
        if (count - events.size() > 0) {
            ArrayList<Event> generatedEvents = new ArrayList<Event>();
            generatedEvents.addAll(InputGenerator.getRandomEventsSequence((FBType)typeCopy, (int)(count - events.size())));
            ServiceSequenceAssignView.addToGenSequence(typeCopy, seq, generatedEvents, true);
        }
    }

    private static String formatInputParameter(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append("; \n");
        }
        return sb.toString();
    }

    private static void addToGenSequence(FBType fbType, ServiceSequence seq, List<Event> eventList, boolean isRandom) {
        FBType typeCopy = (FBType)EcoreUtil.copy((EObject)fbType);
        EventManager eventManager = EventManagerFactory.createEventManager((FBType)typeCopy, eventList, (boolean)isRandom, (String)Messages.ServiceSequenceAssignView_START);
        if (!isRandom) {
            TransactionFactory.addTraceInfoTo((EList)eventManager.getTransactions());
        }
        EventManagerUtils.process((EventManager)eventManager);
        for (Transaction transaction : eventManager.getTransactions()) {
            ServiceSequenceUtils.convertTransactionToServiceModel((ServiceSequence)seq, (FBType)fbType, (FBTransaction)((FBTransaction)transaction));
        }
    }

    private static void setParameters(FBType fbType, List<String> parameters) {
        for (String param : parameters) {
            String[] paramValues = param.split(":=", 2);
            if (paramValues.length != 2) continue;
            VariableUtils.setVariable((FBType)fbType, (String)paramValues[0], (String)paramValues[1]);
        }
    }

    private static Event findEvent(FBType fbType, String eventName) {
        Event event = (Event)fbType.getInterfaceList().getInterfaceElement(eventName);
        if (event == null || !event.isIsInput()) {
            throw new IllegalArgumentException("input primitive: event " + eventName + " does not exist");
        }
        return event;
    }
}

