/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.buildpath;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.buildpath.Attribute;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathFactory;

public final class BuildpathAttributes {
    @AttributeType(value=Boolean.class)
    @AttributeDefault(value="false")
    public static final String IGNORE_WARNINGS = "ignore_warnings";
    @AttributeType(value=Boolean.class)
    @AttributeDefault(value="true")
    public static final String EXPORT = "export";
    private static final Map<String, Field> ATTRIBUTES = Stream.of(BuildpathAttributes.class.getDeclaredFields()).filter(field -> field.isAnnotationPresent(AttributeType.class)).collect(Collectors.toUnmodifiableMap(BuildpathAttributes::getAttributeName, Function.identity()));

    public static List<Attribute> addDefaultAttributes(List<Attribute> attributes) {
        Set names = attributes.stream().map(Attribute::getName).collect(Collectors.toSet());
        ATTRIBUTES.entrySet().stream().filter(entry -> !names.contains(entry.getKey())).map(entry -> BuildpathAttributes.createAttribute((String)entry.getKey(), (Field)entry.getValue())).filter(Objects::nonNull).forEachOrdered(attributes::add);
        if (attributes instanceof EList) {
            EList attributesEList = (EList)attributes;
            ECollections.sort((EList)attributesEList, Comparator.comparing(Attribute::getName));
        } else {
            attributes.sort(Comparator.comparing(Attribute::getName));
        }
        return attributes;
    }

    public static List<Attribute> removeDefaultAttributes(List<Attribute> attributes) {
        attributes.removeIf(BuildpathAttributes::hasDefaultValue);
        return attributes;
    }

    public static Attribute createAttribute(String name) {
        return BuildpathAttributes.createAttribute(name, ATTRIBUTES.get(name));
    }

    private static Attribute createAttribute(String name, Field field) {
        Attribute result = BuildpathFactory.eINSTANCE.createAttribute();
        result.setName(name);
        if (field != null && field.isAnnotationPresent(AttributeDefault.class)) {
            result.setValue(field.getAnnotation(AttributeDefault.class).value());
        }
        return result;
    }

    public static Optional<Attribute> getAttribute(List<Attribute> attributes, String name) {
        return attributes.stream().filter(attribute -> name.equals(attribute.getName())).findAny();
    }

    public static String getAttributeValue(List<Attribute> attributes, String name) {
        return BuildpathAttributes.getAttribute(attributes, name).map(Attribute::getValue).orElseGet(() -> BuildpathAttributes.getAttributeDefault(name));
    }

    public static boolean hasDefaultValue(Attribute attribute) {
        return Objects.equals(attribute.getValue(), BuildpathAttributes.getAttributeDefault(attribute.getName()));
    }

    public static Class<?> getAttributeType(String name) {
        Field field = ATTRIBUTES.get(name);
        if (field != null && field.isAnnotationPresent(AttributeType.class)) {
            return field.getAnnotation(AttributeType.class).value();
        }
        return null;
    }

    public static String getAttributeDefault(String name) {
        Field field = ATTRIBUTES.get(name);
        if (field != null && field.isAnnotationPresent(AttributeDefault.class)) {
            return field.getAnnotation(AttributeDefault.class).value();
        }
        return null;
    }

    private static String getAttributeName(Field field) {
        try {
            return (String)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private BuildpathAttributes() {
        throw new UnsupportedOperationException();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface AttributeDefault {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface AttributeType {
        public Class<?> value();
    }
}

