/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.actions.CopyPasteData;
import org.eclipse.fordiac.ide.application.commands.ConnectionReference;
import org.eclipse.fordiac.ide.application.commands.MoveAndReconnectCommand;
import org.eclipse.fordiac.ide.application.commands.PasteCommand;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.policies.ContainerResizePolicy;
import org.eclipse.fordiac.ide.application.policies.FBNetworkElementNonResizeableEP;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedResizeablePolicy;
import org.eclipse.fordiac.ide.gef.utilities.RequestUtil;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeGroupBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppBoundsCommand;
import org.eclipse.fordiac.ide.model.commands.change.FBNetworkElementSetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.change.RemoveElementsFromGroup;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class FBNetworkXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        SubApp subApp;
        Object model = child.getModel();
        if (model instanceof Group || model instanceof SubApp && (subApp = (SubApp)model).isUnfolded()) {
            return new ContainerResizePolicy();
        }
        if (model instanceof Comment) {
            return new ModifiedResizeablePolicy();
        }
        if (model instanceof FBNetworkElement) {
            return new FBNetworkElementNonResizeableEP();
        }
        return new ModifiedNonResizeableEditPolicy();
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if ((child.getModel() instanceof Group || child.getModel() instanceof SubApp || child.getModel() instanceof Comment) && RequestUtil.isResizeRequest((Request)request)) {
            return this.createChangeSizeCommand((FBNetworkElement)child.getModel(), request, (Rectangle)constraint);
        }
        Object object = child.getModel();
        if (object instanceof PositionableElement) {
            PositionableElement pe = (PositionableElement)object;
            if (RequestUtil.isMoveRequest((Request)request)) {
                return FBNetworkXYLayoutEditPolicy.createMoveCommand(pe, (Rectangle)constraint);
            }
        }
        return null;
    }

    private Command createChangeSizeCommand(FBNetworkElement container, ChangeBoundsRequest request, Rectangle constraint) {
        Dimension sizeDelta = this.getScaledSizeDelta(request);
        if (sizeDelta.width == 0 && sizeDelta.height == 0) {
            return FBNetworkXYLayoutEditPolicy.createMoveCommand((PositionableElement)container, constraint);
        }
        Point moveDelta = this.getScaledMoveDelta(request);
        return FBNetworkXYLayoutEditPolicy.createChangeBoundsCommand(container, sizeDelta, moveDelta);
    }

    public static AbstractChangeContainerBoundsCommand createChangeBoundsCommand(FBNetworkElement container, Dimension sizeDelta, Point moveDelta) {
        if (container instanceof Group) {
            Group group = (Group)container;
            return new ChangeGroupBoundsCommand(group, moveDelta.x, moveDelta.y, sizeDelta.width, sizeDelta.height);
        }
        if (container instanceof SubApp) {
            SubApp subApp = (SubApp)container;
            return new ChangeSubAppBoundsCommand(subApp, moveDelta.x, moveDelta.y, sizeDelta.width, sizeDelta.height);
        }
        if (container instanceof Comment) {
            Comment comment = (Comment)container;
            return new ChangeCommentBoundsCommand(comment, moveDelta.x, moveDelta.y, sizeDelta.width, sizeDelta.height);
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request != null) {
            Object childClass = request.getNewObjectType();
            Point insertPoint = this.getInsertPoint(request);
            FBNetwork fbNetwork = this.getFBNetwork();
            if (fbNetwork != null && childClass instanceof TypeEntry) {
                TypeEntry typeEntry = (TypeEntry)childClass;
                return AbstractCreateFBNetworkElementCommand.createCreateCommand((TypeEntry)typeEntry, (FBNetwork)fbNetwork, (int)insertPoint.x, (int)insertPoint.y);
            }
        }
        return null;
    }

    protected Point getInsertPoint(CreateRequest request) {
        Point insertPoint = ((Rectangle)this.getConstraintFor(request)).getTopLeft();
        SnapToHelper helper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
        if (helper != null) {
            this.getHost().getFigure().translateToAbsolute((Translatable)insertPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(insertPoint);
            PrecisionPoint result = new PrecisionPoint(insertPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            this.getHost().getFigure().translateToRelative((Translatable)result);
            return result;
        }
        return insertPoint;
    }

    protected Command getAddCommand(Request request) {
        if (FBNetworkXYLayoutEditPolicy.isDragAndDropRequestToRoot(request, this.getTargetEditPart(request))) {
            return this.handleDragToRootRequest((ChangeBoundsRequest)request);
        }
        return null;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }

    private Command handleDragToRootRequest(ChangeBoundsRequest request) {
        List editParts = request.getEditParts();
        Point destination = this.getTranslatedAndZoomedPoint(request);
        List<FBNetworkElement> fbEls = FBNetworkXYLayoutEditPolicy.collectDraggedFBs(editParts, this.getFBNetwork());
        if (!fbEls.isEmpty()) {
            return new MoveAndReconnectCommand(fbEls, destination, (FBNetwork)this.getHost().getModel());
        }
        return this.createRemoveFromGroup(editParts, request);
    }

    private Command createRemoveFromGroup(List<? extends EditPart> editParts, ChangeBoundsRequest request) {
        List<FBNetworkElement> fbEls;
        GroupContentEditPart groupContent = FBNetworkXYLayoutEditPolicy.getGroupContentEditPart(editParts);
        if (groupContent != null && !(fbEls = FBNetworkXYLayoutEditPolicy.collectFromGroupDraggedFBs(editParts)).isEmpty()) {
            Point topLeft = groupContent.getFigure().getBounds().getTopLeft();
            Point moveDelta = this.getScaledMoveDelta(request);
            topLeft.translate(moveDelta.x, moveDelta.y);
            return new RemoveElementsFromGroup(fbEls, topLeft);
        }
        return null;
    }

    protected Point getTranslatedAndZoomedPoint(ChangeBoundsRequest request) {
        Point location = request.getLocation().getCopy();
        this.getHost().getFigure().translateToRelative((Translatable)location);
        return location;
    }

    private static List<FBNetworkElement> collectDraggedFBs(List<? extends EditPart> editParts, FBNetwork fbNetwork) {
        return editParts.stream().filter(ep -> ep.getModel() instanceof FBNetworkElement).map(ep -> (FBNetworkElement)ep.getModel()).filter(el -> !el.getFbNetwork().equals(fbNetwork)).toList();
    }

    private static GroupContentEditPart getGroupContentEditPart(List<? extends EditPart> editParts) {
        return editParts.stream().filter(ep -> ep.getParent() instanceof GroupContentEditPart).map(EditPart::getParent).findFirst().orElse(null);
    }

    private static List<FBNetworkElement> collectFromGroupDraggedFBs(List<? extends EditPart> editParts) {
        return editParts.stream().filter(ep -> ep.getParent() instanceof GroupContentEditPart).map(ep -> (FBNetworkElement)ep.getModel()).toList();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        CopyPasteData copyPasteData = new CopyPasteData(this.getFBNetwork());
        request.getEditParts().stream().map(n -> (EObject)n.getModel()).forEach(m -> {
            if (m instanceof FBNetworkElement) {
                FBNetworkElement el = (FBNetworkElement)m;
                copyPasteData.elements().add(el);
            }
            if (m instanceof Connection) {
                Connection conn = (Connection)m;
                copyPasteData.conns().add(new ConnectionReference(conn));
            }
        });
        Point scaledPoint = this.getDestinationPoint(request);
        return new PasteCommand(copyPasteData, this.getFBNetwork(), scaledPoint.x, scaledPoint.y);
    }

    private Point getDestinationPoint(ChangeBoundsRequest request) {
        return this.getScaledMoveDelta(request);
    }

    public static boolean isDragAndDropRequestToRoot(Request generic, EditPart targetEditPart) {
        return generic instanceof ChangeBoundsRequest && (targetEditPart instanceof FBNetworkEditPart || targetEditPart instanceof EditorWithInterfaceEditPart) && !(targetEditPart instanceof UnfoldedSubappContentEditPart) && !(targetEditPart instanceof GroupContentEditPart);
    }

    private FBNetwork getFBNetwork() {
        FBNetwork fbNetwork;
        Object object = this.getHost().getModel();
        return object instanceof FBNetwork ? (fbNetwork = (FBNetwork)object) : null;
    }

    private static Command createMoveCommand(PositionableElement model, Rectangle constraint) {
        Position newPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(constraint.x, constraint.y);
        if (model instanceof FBNetworkElement) {
            FBNetworkElement fbnEl = (FBNetworkElement)model;
            return new FBNetworkElementSetPositionCommand(fbnEl, newPos);
        }
        return new SetPositionCommand(model, newPos);
    }

    protected Dimension getScaledSizeDelta(ChangeBoundsRequest request) {
        return request.getSizeDelta().getScaled(1.0 / this.getZoomManager().getZoom());
    }

    protected Point getScaledMoveDelta(ChangeBoundsRequest request) {
        return request.getMoveDelta().getScaled(1.0 / this.getZoomManager().getZoom());
    }
}

