/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.eclipse.xtext.ide.server.concurrent.AbstractRequest;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Functions;

public class ReadRequest<V>
extends AbstractRequest<V> {
    private static final Logger LOG = Logger.getLogger(ReadRequest.class);
    private final Functions.Function1<? super CancelIndicator, ? extends V> readOperation;
    private final CompletableFuture<Void> initializer;
    private final ExecutorService executor;

    public ReadRequest(RequestManager requestManager, Functions.Function1<? super CancelIndicator, ? extends V> readOperation, ExecutorService executor) {
        super(requestManager);
        this.readOperation = readOperation;
        this.executor = executor;
        this.initializer = new CompletableFuture();
        this.initializer.thenRun(this::doRun);
    }

    @Override
    protected void cancel(boolean mayInterruptIfRunning) {
        super.cancel(mayInterruptIfRunning);
        if (this.initializer.cancel(mayInterruptIfRunning)) {
            this.cancelResult(mayInterruptIfRunning);
        }
    }

    @Override
    public void run() {
        this.initializer.complete(null);
    }

    private void doRun() {
        if (this.isDone()) {
            return;
        }
        this.executor.submit(() -> {
            try {
                if (this.isDone()) {
                    return;
                }
                this.cancelIndicator.checkCanceled();
                Object readResult = this.readOperation.apply((Object)this.cancelIndicator);
                this.complete(readResult);
            }
            catch (Throwable t) {
                this.logAndCompleteExceptionally(t);
            }
        });
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

