/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ResetRowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.config.DefaultRowReorderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.reorder.event.RowReorderEvent;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private static final Logger LOG = LoggerFactory.getLogger(RowReorderLayer.class);
    public static final String PERSISTENCE_KEY_ROW_INDEX_ORDER = ".rowIndexOrder";
    private final IUniqueIndexLayer underlying;
    protected final MutableIntList rowIndexOrder = IntLists.mutable.empty();
    protected final MutableIntIntMap indexPositionMapping = IntIntMaps.mutable.empty();
    private final MutableIntIntMap startYCache = IntIntMaps.mutable.empty();
    private int reorderFromRowPosition;

    public RowReorderLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public RowReorderLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlying = underlyingLayer;
        this.populateIndexOrder();
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowReorderLayerConfiguration());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged()) {
            Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getRowDiffs();
            if (structuralDiffs == null) {
                this.populateIndexOrder();
            } else {
                StructuralChangeEventHelper.handleRowDelete(structuralDiffs, (ILayer)this.underlying, (MutableIntCollection)this.rowIndexOrder, true);
                StructuralChangeEventHelper.handleRowInsert(structuralDiffs, (ILayer)this.underlying, (MutableIntCollection)this.rowIndexOrder, true);
                this.refreshIndexPositionMapping();
            }
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ConfigureScalingCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RowReorderCommandHandler(this));
        this.registerCommandHandler(new RowReorderStartCommandHandler(this));
        this.registerCommandHandler(new RowReorderEndCommandHandler(this));
        this.registerCommandHandler(new MultiRowReorderCommandHandler(this));
        this.registerCommandHandler(new ResetRowReorderCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        if (this.rowIndexOrder.size() > 0) {
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_INDEX_ORDER, this.rowIndexOrder.makeString(","));
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_INDEX_ORDER);
        if (property != null) {
            MutableIntList newRowIndexOrder = IntLists.mutable.empty();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                newRowIndexOrder.add(Integer.parseInt(index));
            }
            if (this.isRestoredStateValid(newRowIndexOrder.toArray())) {
                this.rowIndexOrder.clear();
                this.rowIndexOrder.addAll((IntIterable)newRowIndexOrder);
                this.refreshIndexPositionMapping();
            }
        }
        this.invalidateCache();
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }

    protected boolean isRestoredStateValid(int[] newRowIndexOrder) {
        if (newRowIndexOrder.length != this.getRowCount()) {
            LOG.error("Number of persisted rows ({}) is not the same as the number of rows in the data source ({}).\nSkipping restore of row ordering", (Object)newRowIndexOrder.length, (Object)this.getRowCount());
            return false;
        }
        int[] nArray = newRowIndexOrder;
        int n = newRowIndexOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (!this.indexPositionMapping.containsKey(index)) {
                LOG.error("Row index: {} being restored, is not a available in the data soure.\nSkipping restore of row ordering", (Object)index);
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlying.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartYOfRowPosition(int targetRowPosition) {
        int cachedStartY = this.startYCache.getIfAbsent(targetRowPosition, -1);
        if (cachedStartY != -1) {
            return cachedStartY;
        }
        int aggregateWidth = 0;
        int rowPosition = 0;
        while (rowPosition < targetRowPosition) {
            aggregateWidth += this.underlying.getRowHeightByPosition(this.localToUnderlyingRowPosition(rowPosition));
            ++rowPosition;
        }
        this.startYCache.put(targetRowPosition, aggregateWidth);
        return aggregateWidth;
    }

    protected void populateIndexOrder() {
        this.rowIndexOrder.clear();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int rowPosition = 0;
        while (rowPosition < underlyingLayer.getRowCount()) {
            int index = underlyingLayer.getRowIndexByPosition(rowPosition);
            this.rowIndexOrder.add(index);
            this.indexPositionMapping.put(index, rowPosition);
            ++rowPosition;
        }
    }

    protected void refreshIndexPositionMapping() {
        this.indexPositionMapping.clear();
        int position = 0;
        while (position < this.rowIndexOrder.size()) {
            int index = this.rowIndexOrder.get(position);
            this.indexPositionMapping.put(index, position);
            ++position;
        }
    }

    public List<Integer> getRowIndexOrder() {
        return ArrayUtil.asIntegerList(this.rowIndexOrder.toArray());
    }

    public int[] getRowIndexOrderArray() {
        return this.rowIndexOrder.toArray();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition >= 0 && rowPosition < this.rowIndexOrder.size()) {
            return this.rowIndexOrder.get(rowPosition);
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.indexPositionMapping.getIfAbsent(rowIndex, -1);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return this.underlying.getRowPositionByIndex(rowIndex);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowIndex = this.underlying.getRowIndexByPosition(underlyingRowPosition);
        return this.getRowPositionByIndex(rowIndex);
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        MutableIntList reorderedRowPositions = IntLists.mutable.empty();
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int underlyingRowPosition = underlyingRowPositionRange.start;
            while (underlyingRowPosition < underlyingRowPositionRange.end) {
                int localRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start);
                reorderedRowPositions.add(localRowPosition);
                ++underlyingRowPosition;
            }
        }
        return PositionUtil.getRanges(reorderedRowPositions.toSortedArray());
    }

    private void moveRow(int fromRowPosition, int toRowPosition, boolean reorderToTopEdge) {
        if (!reorderToTopEdge) {
            ++toRowPosition;
        }
        int fromRowIndex = this.rowIndexOrder.get(fromRowPosition);
        this.rowIndexOrder.addAtIndex(toRowPosition, fromRowIndex);
        this.rowIndexOrder.removeAtIndex(fromRowPosition + (fromRowPosition > toRowPosition ? 1 : 0));
        this.refreshIndexPositionMapping();
        this.invalidateCache();
    }

    public void reorderRowPosition(int fromRowPosition, int toRowPosition) {
        boolean reorderToTopEdge;
        if (toRowPosition < this.getRowCount()) {
            reorderToTopEdge = true;
        } else {
            reorderToTopEdge = false;
            --toRowPosition;
        }
        this.reorderRowPosition(fromRowPosition, toRowPosition, reorderToTopEdge);
    }

    public void reorderRowPosition(int fromRowPosition, int toRowPosition, boolean reorderToTopEdge) {
        int fromRowIndex = this.getRowIndexByPosition(fromRowPosition);
        int toRowIndex = this.getRowIndexByPosition(toRowPosition);
        this.moveRow(fromRowPosition, toRowPosition, reorderToTopEdge);
        this.fireLayerEvent(new RowReorderEvent((ILayer)this, fromRowPosition, fromRowIndex, toRowPosition, toRowIndex, reorderToTopEdge));
    }

    public void reorderMultipleRowPositions(List<Integer> fromRowPositions, int toRowPosition) {
        this.reorderMultipleRowPositions(fromRowPositions.stream().mapToInt(Integer::intValue).toArray(), toRowPosition);
    }

    public void reorderMultipleRowPositions(int[] fromRowPositions, int toRowPosition) {
        boolean reorderToTopEdge;
        if (toRowPosition < this.getRowCount()) {
            reorderToTopEdge = true;
        } else {
            reorderToTopEdge = false;
            --toRowPosition;
        }
        this.reorderMultipleRowPositions(fromRowPositions, toRowPosition, reorderToTopEdge);
    }

    public void reorderMultipleRowPositions(List<Integer> fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        this.reorderMultipleRowPositions(fromRowPositions.stream().mapToInt(Integer::intValue).toArray(), toRowPosition, reorderToTopEdge);
    }

    public void reorderMultipleRowPositions(int[] fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        Arrays.sort(fromRowPositions);
        int[] fromRowIndexes = Arrays.stream(fromRowPositions).map(this::getRowIndexByPosition).toArray();
        int toRowIndex = this.getRowIndexByPosition(toRowPosition);
        int fromRowPositionsCount = fromRowPositions.length;
        if (toRowPosition > fromRowPositions[fromRowPositionsCount - 1]) {
            int firstRowPosition = fromRowPositions[0];
            int moved = 0;
            int rowCount = 0;
            while (rowCount < fromRowPositionsCount) {
                int fromRowPosition = fromRowPositions[rowCount] - moved;
                this.moveRow(fromRowPosition, toRowPosition, reorderToTopEdge);
                ++moved;
                if (fromRowPosition < firstRowPosition) {
                    firstRowPosition = fromRowPosition;
                }
                ++rowCount;
            }
        } else if (toRowPosition < fromRowPositions[fromRowPositionsCount - 1]) {
            int targetRowPosition = toRowPosition;
            int[] nArray = fromRowPositions;
            int n = fromRowPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int fromRowPosition;
                int fromRowPositionInt = fromRowPosition = nArray[n2];
                this.moveRow(fromRowPositionInt, targetRowPosition++, reorderToTopEdge);
                ++n2;
            }
        }
        this.fireLayerEvent(new RowReorderEvent((ILayer)this, fromRowPositions, fromRowIndexes, toRowPosition, toRowIndex, reorderToTopEdge));
    }

    public void reorderMultipleRowIndexes(List<Integer> fromRowIndexes, int toRowPosition, boolean reorderToTopEdge) {
        this.reorderMultipleRowIndexes(fromRowIndexes.stream().mapToInt(Integer::intValue).toArray(), toRowPosition, reorderToTopEdge);
    }

    public void reorderMultipleRowIndexes(int[] fromRowIndexes, int toRowPosition, boolean reorderToTopEdge) {
        int[] fromRowPositions = Arrays.stream(fromRowIndexes).map(this::getRowPositionByIndex).toArray();
        this.reorderMultipleRowPositions(fromRowPositions, toRowPosition, reorderToTopEdge);
    }

    protected void invalidateCache() {
        this.startYCache.clear();
    }

    public int getReorderFromRowPosition() {
        return this.reorderFromRowPosition;
    }

    public void setReorderFromRowPosition(int fromRowPosition) {
        this.reorderFromRowPosition = fromRowPosition;
    }

    public void resetReorder() {
        this.populateIndexOrder();
        this.invalidateCache();
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }
}

