/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.ui.actions.IOpenListener;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public enum OpenListenerManager {
    INSTANCE;

    private static final String PLUGIN_ID = "org.eclipse.fordiac.ide.model.ui";
    private List<IOpenListener> openListeners = null;

    List<IOpenListener> getOpenListeners() {
        if (this.openListeners == null) {
            this.loadOpenListeners();
        }
        return this.openListeners;
    }

    public List<IOpenListener> getOpenListener(EObject elementToOpen) {
        ArrayList<IOpenListener> listeners = new ArrayList<IOpenListener>();
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!OpenListenerManager.listenerSupportsElement(openListener, elementToOpen)) continue;
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            listeners.add(openListener);
        }
        return listeners;
    }

    public static void setDefaultOpenListener(Class<? extends EObject> libElement, String id) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        preferences.put(libElement.getName(), id);
    }

    public IOpenListener getDefaultOpenListener(EObject elementToOpen) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        for (IOpenListener openListener : this.getOpenListeners()) {
            if (!OpenListenerManager.listenerSupportsElement(openListener, elementToOpen)) continue;
            String value = preferences.get(openListener.getHandledClass().getName(), "");
            openListener.selectionChanged(null, (ISelection)new StructuredSelection((Object)elementToOpen));
            if (!"".equals(value) && !value.equals(openListener.getOpenListenerID())) continue;
            return openListener;
        }
        return null;
    }

    public static IEditorPart openEditor(EObject element) {
        IOpenListener openListener = INSTANCE.getDefaultOpenListener(element);
        if (openListener != null) {
            openListener.run(null);
            return openListener.getOpenedEditor();
        }
        if (element instanceof LibraryElement) {
            LibraryElement libEl = (LibraryElement)element;
            return OpenListenerManager.openDefaultEditorForFile(libEl);
        }
        return null;
    }

    static IEditorPart openDefaultEditorForFile(LibraryElement element) {
        TypeEntry entry = element.getTypeEntry();
        if (entry != null) {
            IFile file = entry.getFile();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            try {
                IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
                OpenListenerManager.checkBreadCrumb(part, element);
                return part;
            }
            catch (PartInitException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    static void checkBreadCrumb(IEditorPart part, LibraryElement element) {
        AbstractBreadCrumbEditor breadCrumbEditor;
        if (part != null && (breadCrumbEditor = (AbstractBreadCrumbEditor)((Object)part.getAdapter(AbstractBreadCrumbEditor.class))) != null) {
            breadCrumbEditor.getBreadcrumb().setInput(element);
        }
    }

    private void loadOpenListeners() {
        IConfigurationElement[] elems;
        this.openListeners = new ArrayList<IOpenListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor(PLUGIN_ID, "openListener");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IOpenListener) {
                    IOpenListener openListener = (IOpenListener)object;
                    this.openListeners.add(openListener);
                }
            }
            catch (CoreException corex) {
                FordiacLogHelper.logError((String)corex.getMessage(), (Throwable)corex);
            }
            ++n2;
        }
    }

    private static boolean listenerSupportsElement(IOpenListener listener, EObject elementtoOpen) {
        return listener.getHandledClass() != null && listener.getHandledClass().isInstance(elementtoOpen);
    }
}

