/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.dialog;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;

public abstract class AbstractTypeEntryDataHandler<T extends TypeEntry> {
    protected final T typeEntry;
    protected final Map<String, Set<INamedElement>> children;
    protected Map<INamedElement, T> inputSet;

    protected AbstractTypeEntryDataHandler(T typeEntry) {
        this.typeEntry = typeEntry;
        this.children = new HashMap<String, Set<INamedElement>>();
        this.setInputSet(new HashMap());
    }

    public T getTypeEntry() {
        return this.typeEntry;
    }

    public Map<INamedElement, T> getInputSet() {
        return this.inputSet;
    }

    public void setInputSet(Map<INamedElement, T> inputSet) {
        this.inputSet = inputSet;
    }

    public Map<String, Set<INamedElement>> getChildren() {
        return this.children;
    }

    public Set<INamedElement> getChild(String key) {
        return this.children.get(key);
    }

    public Set<INamedElement> putChild(String key, Set<INamedElement> child) {
        return this.children.put(key, child);
    }

    public Set<INamedElement> getCollectedElements() {
        return this.inputSet.keySet();
    }

    public T getTypeOfElement(Object element) {
        if (element instanceof INamedElement) {
            INamedElement iNamedElement = (INamedElement)element;
            if (this.getInputSet().containsKey(iNamedElement)) {
                return (T)((TypeEntry)this.getInputSet().get(iNamedElement));
            }
        }
        return null;
    }

    public List<T> getTypeOfElementList(List<?> elements) {
        return elements.stream().map(e -> this.getTypeOfElement(e)).toList();
    }

    public boolean loadInputSet() {
        this.inputSet = this.createInputSet(this.typeEntry);
        return this.inputSet.isEmpty();
    }

    protected abstract Map<INamedElement, T> createInputSet(T var1);
}

