/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.data.StringType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.CharValue;
import org.eclipse.fordiac.ide.model.eval.value.StringValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class StringCharacterVariable
extends AbstractVariable<CharValue> {
    private final Variable<StringValue> delegate;
    private final int index;

    public StringCharacterVariable(Variable<StringValue> delegate, int index) {
        super(delegate.getName() + "[" + index + "]", (INamedElement)IecTypes.ElementaryTypes.CHAR);
        this.delegate = delegate;
        this.index = index;
    }

    @Override
    public CharValue getValue() {
        return this.delegate.getValue().charAt(this.index);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(Value value) {
        void charValue;
        if (!(value instanceof CharValue)) {
            throw this.createCastException(value);
        }
        CharValue charValue2 = (CharValue)value;
        StringType type = (StringType)this.delegate.getType();
        if (this.index > (type.isSetMaxLength() ? type.getMaxLength() : 65534)) {
            throw new StringIndexOutOfBoundsException(this.index);
        }
        this.delegate.setValue(this.delegate.getValue().withCharAt(this.index, (CharValue)charValue));
    }

    public CharType getType() {
        return (CharType)super.getType();
    }
}

