/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.LintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class LIntValue
implements AnySignedValue {
    public static final LIntValue DEFAULT = new LIntValue(0L);
    private final long value;

    private LIntValue(long value) {
        this.value = value;
    }

    public static LIntValue toLIntValue(long value) {
        return new LIntValue(value);
    }

    public static LIntValue toLIntValue(Number value) {
        return new LIntValue(value.longValue());
    }

    public static LIntValue toLIntValue(String value) {
        return LIntValue.toLIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static LIntValue toLIntValue(AnyMagnitudeValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    public LintType getType() {
        return IecTypes.ElementaryTypes.LINT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LIntValue other = (LIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

